"Slicker City" by Andrew Schultz

[index for searching for tables (starting double-x not listed so this isn't flagged
 table of unvisiteds: u
 table of explanations: add
 all the concepts: cv
 endgame code: end
 printing locale description: ap
]

the story headline is "Bit Two of the Alec Smart saga"

include Basic Screen Effects by Emily Short.

include Trivial Niceties by Andrew Schultz.

include In-Game Mapping by Andrew Schultz.

Include (- Switches z; -) after "ICL Commands" in "Output.i6t".

Release along with an interpreter.

volume globals and such

a thing can be examined. a thing is usually not examined.

a thing can be unflip. a thing is usually not unflip.

after examining:
	if noun provides the property examined:
		now noun is examined;
	continue the action;

to say bad-guy-pc:
	say "[if swears is true]Baiter Master[else]Complex Messiah[end if]"

to say vbad-pc:
	say "[if swears is true]Buster Ball[else]Hunter Savage[end if]"

to say stwid:
	now swears is whether or not swears is false;

stop-on-bug is a truth state that varies.

to say bug:
	if debug-state is true:
		if stop-on-bug is true:
			say "OOPS! A programmer-testing-killing bug.";
			end the story;
	say "BUG! If you let me know at [email] or report the bug at [my-repo] I'd be grateful. If you can include [if currently transcripting]the current[else]a[end if] transcript, even better. Thanks, and sorry, though--you may get in my ABOUT section for finding this!";
	unless currently transcripting:
		say "You're not currently transcripting, but you can try to cut and paste text, or you can undo a few times, TRANSCRIPT and then redo."

to say email:
	say "blurglecruncheon@gmail.com";

to say my-repo:
	say "http://bitbucket.com/andrewschultz/slicker-city"

a room can be retro-anno. a room is usually not retro-anno.

to decide what region is mrlp: [I'd include this in a header but it complains if you don't use regions]
	decide on map region of location of Alec.

woof-warp is a truth state that varies.

cross-warp is a truth state that varies.

section compiler debug

[without these numbers beiing increased, the I7 would be translated to I6, but the I6 compiler would complain. Maybe there aren't any yet, but as a game gets bigger, eventually one forces me to make this section.]

use MAX_PROP_TABLE_SIZE of 100000.
use MAX_OBJECTS of 180.

section procedural rules

Procedural rule while eating something: ignore the carrying requirements rule.

section procedurality stub

to decide whether the action is procedural: [aip]
	if srching, yes;
	if examining, yes;
	if attacking, yes;
	if saying yes, yes;
	if saying no, yes;
	if dropping, yes;
	if looking, yes;
	if listening, yes;
	no;

volume parser errors

Rule for printing a parser error when the latest parser error is the i beg your pardon error:
	say "[activation of not your type]Type? You're not!"

Rule for printing a parser error when the latest parser error is the noun did not make sense in that context error:
	if word number 1 in the player's command is "x" or word number 1 in the player's command is "examine":
		say "You can't see anything here like that. Well, nothing critical to solving the game.";
		the rule succeeds;
	say "You tried to access something not currently in the world. Maybe that's a result of a typo, or it's minor scenery I forgot to implement and should've, or a bad synonym. But it's not critical to the game."

rule for printing a parser error when the latest parser error is the only understood as far as error:
	say "The first word was okay, and you don't need any extra ones."

rule for printing a parser error when the latest parser error is the can't see any such thing error:
	say "I (you) can't see anything here like that."

rule for printing a parser error when the latest parser error is the didn't understand error:
	if Alec Smart is in comedy-club and Kay is in comedy-club:
		say "Hmm, I couldn't do anything with that. But you'll want to do something with that laugh." instead;
	if Alec Smart is in snipe gutter and Terry is in snipe gutter:
		say "Hmm, I couldn't do anything with that. But some sort of pithy comment might get Terry off-balance." instead;
	if Alec Smart is in lent-you-corp and roll is in lent-you-corp:
		say "Hmm, I couldn't do anything with that. But there has to be a way to muck with the Player Roll." instead;
	if Alec Smart is in bluff and grate is in bluff:
		say "Hmm, that doesn't seem to be an effective way to dispose of the grate. But you'll figure out what to do. There's got to be more than one way." instead;
	if mrlp is pondering:
		say "There's not much to do here except wait, or go any direction to leave." instead;
	say "I didn't recognize that verb. For a list of common/useful verbs, type V or VERB or VERBS.";
	the rule succeeds;

volume when play begins

pc-dif is a truth state that varies.

screenreader is a truth state that varies.

swears is a truth state that varies. swears is true.

to force-status: (- DrawStatusLine(); -);

when play begins (this is the narrative introduction rule):
	now the right hand status line is "[up-right]";
	now the left hand status line is "[location of Alec Smart] ([mrlp])";
	force-status;
	say "Before we start, Slicker City has a feature that makes it slightly easier to read on a screen reader. Are you using a screen reader?";
	if the player no-consents:
		now screenreader is true;
	else:
		now screenreader is false;
	say "Your trip to the Problems Compound so many years ago--it was fun, a confidence boost, and it gave perspective. But you put it aside. Things like that just don't happen twice. You've avoided the worst of guilt trips from other classmates, but after a semester and a half at college, you expected, well, more. Of grades, of social life. People luckier in life than you, or less lucky, leave you feeling you haven't done enough. In fact, you've beaten yourself up that even getting lucky enough to visit the Problems Compound, you're not really taking ENOUGH advantage.";
	wfak;
	say "[line break]It's meant a lot of walks, over spring break. You need that balance between being sure of where you're going and a bit of adventure, but it's either too much of one or the other. While trying to remember lyrics you know you got wrong, you walk past a park you haven't seen before. Hmm, [activation of mondegreen]Green Monde.";
	wfak;
	say "[line break]You've never been here. It looks like a nice place to reflect, even think of things a bit wrong, get new perspective, and feel original and work out of a rut you had. It's weird and zigzaggy if you want it to be. And new. You step on something that gets stuck in your shoe. It's a spring. You pick it up but manage somehow to break the spring. Then you look around and feel a bit lost.";
	wfak;

max-infl is a number that varies. cur-pop is a number that varies.

when play begins (this is the scramble and initialize it all rule) : [rand]
	let cur-auth be 0;
	repeat through table of explanations:
		if there is no exp-thing entry:
			now exp-thing entry is Alec Smart;
			break;
	sort the table of picks in random order;
	sort the table of homonym ads in random order;
	sort the table of charms in random order;
	sort the table of netness in random order;
	sort the table of acheies in random order; [the 4 mists]
	sort the table of oldies in random order; [the 4 mists]
	sort the table of eerieies in random order; [the 4 mists]
	sort the table of rusties in random order; [the 4 mists]

volume standard verbs

before taking a person:
	say "You're no extreme weightlifter." instead;

the block throwing at rule is not listed in any rulebook

instead of throwing at:
	say "Throwing is not necessary in this game."

understand the command "kiss" as something new.

understand the command "buy" as something new.

understand the command "burn" as something new.

understand the command "jump" as something new.

book smelling

the block smelling rule is not listed in any rulebook.

instead of smelling:
	say "You don't need to use your sense of smell in this game."

book eating

the can't eat unless edible rule is not listed in any rulebook

check eating:
	say "You're hungry for answers, not food. Of which there is none in this game.";

book pushing

check pushing a person:
	if noun is alec:
		say "People do tell you PUSH YOURSELF, but not literally." instead;
	say "No need to start a scuffle here." instead;

check pushing roll:
	say "It's too big." instead;

check pushing crasher gate:
	say "That might set off an alarm." instead;

book singing

instead of singing:
	if map region of location of alec is preamble:
		say "Singing would break the sort-of silence here." instead;
	if player is in cadet space:
		say "Don't encourage the Chump to strike up a protest song." instead;
	say "You have no idea what to sing."

book X ROOM

xrooming is an action applying to one visible thing.

understand "examine [any room]" as xrooming.
understand "x [any room]" as xrooming.

check xrooming:
	if noun is location of player:
		say "X (ROOM) is equivalent to LOOK in Slicker City.";
		try looking instead;
	if noun is visited:
		say "You've been there, but you can't see that far[x-room-n].";
	else:
		say "You haven't gotten there yet, and you can't see that far[x-room-n].";

to say x-room-n:
	say "[one of]. X ROOM is really just the same as LOOK for the room you're in, and you don't need to look ahead or behind[or][stopping]"

book searching

srching is an action applying to one thing.

understand the command "search" as something new.

understand "search [thing]" as srching.

understand "look on/behind/under/inside [thing]" as srching.

srch-x is a truth state that varies.

check srching:
	if srch-x is false:
		say "(Note: for the purposes of this game, SEARCH and X/EXAMINE are equivalent.)[paragraph break]";
		now srch-x is true;
	try examining the noun instead;

book talking to

talking to is an action applying to one thing.

understand the command "talk to" as something new.
understand the command "t/ask/talk" as something new.

understand "talk to [thing]" as talking to.

understand "t [thing]" as talking to.

understand "talk [thing]" as talking to.

understand "ask [thing]" as talking to.

carry out talking to:
	if noun is not a person:
		say "That's not a living thing." instead;
	if noun is Change Chump:
		say "The Change Chump barely acknowledges you, then carries on muttering slogans and searching." instead;
	if noun is Kay Riss:
		say "Kay Riss shushes you. 'No hecklers, please! It gets in the way of the laugh!' The laugh...coming from WHERE?" instead;
	if noun is terry common:
		say "You're unable to get a word in. Well, actually, you can get one in, as a common. But two? No. Perhaps you need a one-syllable word, just to be sure you get it in." instead;
	say "You thought you had something to say, but you didn't. Awkward! That might not be your fault, though. It might be mine." instead;

book disabling

understand the command "wave" as something new.

book giving to

checkgiving it to is an action applying to two things.

Understand "give [something preferably held] to [something]" as checkgiving it to.

check checkgiving it to:
	if second noun is a person:
		try giving noun to second noun instead;
	say "You may rather USE something ON, instead of GIVEing to an inanimate object. Do so now?";
	if the player consents:
		try useoning noun with second noun instead;
	else:
		say "OK.";
	the rule succeeds;

book asking about

ask-check is a truth state that varies.

instead of asking about:
	if ask-check is false:
		say "(Note: TALK TO is the way to talk in the game. Everyone here's got a one-track mind.)";
		now ask-check is true;
	try talking to noun instead;

book listening

the block listening rule is not listed in any rulebook.

check listening:
	if alec is in bees wood:
		say "Bees, not too loud. Relaxing enough." instead;
	if alec is in cadet space:
		say "Ugh. Hard not to listen to the Change Chump." instead;
	if map region of location of alec is preamble:
		say "Just enough nature noises to relax." instead;
	if alec is in delta:
		say "Water rushing. Pretty pleasant, really." instead;
	if alec is in cavity:
		say "You might expect to hear a racket, but you don't." instead;
	if alec is in purposes cross:
		if score < 6:
			now got-big-hint is true;
			say "'[one of]You're on NO MODEL TRACK...'[or]MODEL TRACK? NO...'[in random order] you hear the Town Ghost whisper and moan. Or you think you do." instead;
	if alec is in jungle of law:
		say "It's just...each side of any argument you can get a bead on seems both better thought out and more confident than you." instead;
	if alec is in comedy-club:
		say "An annoying, constant laugh. If you could figure it out, that'd be awesome." instead;
	if alec is in lent-you-corp:
		say "[if roll is in lent-you-corp]The whirring of computers and hard drives[else]Silence, now[end if]." instead;
	say "Nothing unusual." instead;

book dropping

before dropping:
	if noun is an firstpuzzly thing:
		if number of firstpuzzly things held by alec > 1:
			say "Uh oh. There's a bug here. You should've only been able to grab one. So I'm sending this back to the Delta. If you have a transcript, or you remember how, please send it to [email]";
			move noun to delta;
			the rule succeeds;
		say "Hm, no, you probably want [italic type]one[roman type] of the three items from [if Alec is in delta]here. Maybe you can pick up another first, if you want another[else]the Delta[end if]." instead;
	say "Don't worry about dropping anything. You shouldn't need to. Nothing you can carry will be too big." instead;

book pulling

understand the command "pull" as something new.

understand "pull [something]" as pushing.

instead of pushing a person:
	say "You don't have enough pushiness. Or pull." instead;

book directions

chapter going

section diagonals

understand "ws" as southwest.
understand "es" as southeast.

understand "wn" as northwest.
understand "en" as northeast.

before going (this is the diagonals are wrong 99% of the time rule) :
	if noun is southeast or noun is northeast or noun is southwest or noun is northwest:
		say "You don't need to use diagonal directions in this game unless they're specifically mentioned. Up, down, in and out may be specifically mentioned, but otherwise it's just the four basic compass directions. Hopefully this makes it simpler for you." instead;

section nowhere

last-dir is a direction that varies.

check going nowhere (this is the spam can't go that way rule) :
	now last-dir is noun;
	repeat through table of nowheres:
		if location of Alec is theloc entry:
			say "[thereject entry][line break]";
			the rule succeeds;
	if number of viable directions is 0:
		say "You can't go that way--in fact, you can't go any way here. This is a sort of puzzle room." instead;
	else if number of viable directions is 1:
		say "You can only go [if room noun of location of Alec is visited]back [end if][list of viable directions] here." instead;
	if noun is outside:
		say "There may be more than one way to go out, so you'll have to be specific." instead;
	if noun is up:
		say "There are no stairs, and there's no way to fly." instead;
	if noun is down:
		say "There is no way to burrow down." instead;

table of nowheres
theloc	thereject
delta of delta	"The water spreads out and prevents you going any way except back north."
crazy bureau	"As crazy as the Crazy Bureau is, it only has passages west and east."
way of right	"You can go every way except east and in, here."
purposes cross	"You can go every way except out and up, here."
Production Peak	"The passage is north-south, or you can go in."
Way-Out Bluff	"You can go in, south to [if bare cave is visited]Bare Cave[else]a cave[end if], or back up Bull Gully to Purposes Cross."
Profit Turn	"You can go any cardinal direction here, or up[if context device is not off-stage], or down[end if]."
comedy-club	"Running into walls would not really be shocking enough. You can, however, leave west or south."
Lent-You-Corp	"In this underground den, you can only go south [if back-to-law is true]or back up [end if]to the Jungle of Law, or north[if back-to-law is false] or back up[end if] to Profit Turn."

to say wait-out:
	say "There's no way to run or climb or dig. You'll have to WAIT things out."

book attacking

instead of attacking:
	if noun is tripuzzly:
		say "Yes. It would be nice to destroy the [noun]. But you can't do so with your bare hands." instead;
	if noun is wordpuzzly:
		say "You may need your wits to deal with things here, instead." instead;
	if noun is Kay or noun is Terry:
		say "You may need to outmaneuver [noun] with words, instead." instead;
	say "You've got a lot less pent-up hostility in general than you used to, but you don't need to do that." instead;

book cutting

instead of cutting neutrality net:
	if Alec has poker strip:
		say "(with the poker strip)";
		try useoning poker strip with neutrality net instead;
	if Alec has worm hook:
		say "(with the worm hook)";
		try useoning worm hook with neutrality net instead;
	if Alec has poker strip:
		say "(with the proof bullet)";
		try useoning proof bullet with neutrality net instead;
	say "You lack an item sharp enough."

book singing

check singing:
	say "You'd probably be assessed a [activation of fine tuning]tuning fine, or worse.";

book giving

Understand "give [something preferably held] to [thing]" as giving it to.
[the below seems logical but is disabled as it wreaks havoc with syntax e.g. GIVE TOKEN]
[Understand "give [thing] [something preferably held]" as giving it to (with nouns reversed).]

does the player mean giving to a person: it is very likely.

understand the command "present" as something new.
understand the command "show" as something new.
understand the command "display" as something new.

understand the commands "show" and "present" and "display" as "give".

give-obj-warn is a truth state that varies.

section before giving stubs

[this is largely to redirect giving to non-persons]

before giving to (this is the warn against giving to nonperson rule):
	if second noun is not a person:
		if give-obj-warn is false:
			say "(NOTE: instead of GIVEing to an inanimate object, you may wish to PUT X ON/IN Y instead.)[line break]";
			now give-obj-warn is true;

the can't give to yourself rule is not listed in any rulebook.
the block giving rule is not listed in any rulebook.

before giving to yourself:
	say "That won't do any good." instead;

chapter giving effort token

check giving token to:
	if second noun is change chump:
		say "[one of]'That? Hmph, well, it can't be worth much. You keep it. I'm a big thinker, here.'[or]He's already said it's worthless to him.[stopping]" instead;
	if second noun is protector pocket:
		try inserting token into protector pocket instead;

chapter default fall-through

check giving (this is the default fall-through giving rule) :
	if second noun is not a person:
		say "You should probably GIVE stuff to people. For inanimate objects, try PUT X ON/IN Y." instead;
	if noun is firstpuzzly:
		say "No way! That's given you some confidence." instead;
	say "You're not feeling terribly generous." instead;

book saying yes/no

instead of saying yes:
	prod-current true;

instead of saying no:
	prod-current false;

rhet-hint is a truth state that varies.

to prod-current (ts - a truth state):
	say "Oh, [if ts is true][activation of type o positive]positive[else][activation of type o negative]negative[end if] type!";
	if rhet-hint is false:
		say "[line break]";
		ital-say "rhetorical questions don't need an answer, and yes/no questions will always give a specific prompt.";
		now rhet-hint is true;

book swearing

instead of swearing obscenely:
	if swears is true:
		say "No fair! You said you didn't want even innuendo, yet...";
		say "[line break]";
	say "[one of]Raucous cuss! Raw![or][activation of whale of a time]Time of a Wail![in random order]";

instead of swearing mildly:
	say "[activation of lame duck]Duck LAME."

book look under

luing is an action applying to one thing.

understand the command "look under" as something new.

understand "look under [something]" as luing.

lu-warn is a truth state that varies.

check luing:
	if lu-warn is false:
		now lu-warn is true;
		say "(Note: LOOK UNDER is equivalent to EXAMINE in Slicker City.)[paragraph break]";
	try examining noun instead;

book thinking

to say am-here of (amr - a room):
	say "[if alec is in amr]here[else][amr][end if]";

instead of thinking:
	if score is 5 and got-big-hint is true:
		say "The 'NO MODEL TRACK' quote from [am-here of purposes cross] rings in your ear." instead;
	if in-beta is true and mrlp is partnership:
		say "You can have the puzzle spoiled as a beta-tester. Do you wish to?";
		if the player consents:
			say "[if Alec is in comedy-club]TRACK LAUGH[else if Alec is in lent-you-corp]MODEL ROLL[else if Alec is in snipe gutter]COMMENT NO[end if]." instead;
	if bluff is visited and grate is in bluff:
		say "You need to act or think your way past the grate. Great!" instead;
	else if things-gone < 3:
		if way of right is unvisited or profit turn is unvisited or jungle of law is unvisited:
			say "You haven't explored everywhere, yet." instead;
		say "The [list of tripuzzly things] still vex you, a bit." instead;
	else if bare cave is visited:
		if snowflake special is in bare cave:
			say "You can just enter the Snowflake Special." instead;
		say "You need to figure how to operate the people pod." instead;
	if things-gone is 3:
		say "Bull Gully doesn't seem scary at all now." instead;
	repeat with Q running through ites:
		if Alec Smart has Q:
			say "You probably need to do something with [the Q].";
			the rule succeeds;
	if mrlp is pondering:
		say "There's probably nothing critical here, so you can just exit." instead;
	else if map region of location of alec is preamble:
		say "You just need to wander any which way." instead;
	else if effort token is off-stage:
		say "Maybe if you search Cadet Space, something will turn up." instead;
	else if wait paper is off-stage:
		say "Cadet Space could use extra decor." instead;
	else if tiger paper is off-stage:
		say "How could you convert the wait paper to something more valuable?" instead;
	else if Alec Smart has tiger paper:
		say "Where could you show the tiger paper for verification?" instead;
	else if delta is unvisited:
		say "You have one more place to visit west of Crazy Bureau." instead;
	else if bottle is off-stage or number of firstpuzzly things in delta is 3:
		say "You might want or need something from the [if delta is visited]Delta[else]room back west you didn't explore[end if]." instead;
	else if Alec Smart has bottle of bottle:
		say "[if comedy-club is visited]The bottle got you in [comedy-club], but what to do there?[else]You don't know if you've visited EVERYWHERE in Slicker City." instead;
	else if Alec Smart has jars of jars:
		say "[if snipe gutter is visited]The jars got you in Snipe Culture, but what to do there?[else]You don't know if you've visited EVERYWHERE in Slicker City." instead;
	else if Alec Smart has solution of solution:
		say "[if Lent-You-Corp is visited]The solution got you in Lent-You-Corp, but what to do there?[else]You don't know if you've visited EVERYWHERE in Slicker City." instead;
	say "You draw a blank. Or rather, my code is drawing a blank. Sorry."

ites is a list of things that varies. ites is { context device, proof bullet, light engine, under buckle, upright bolt, worm hook, poker strip, guzzler gas, bawl slime }.

book score

the maximum score is 11.

never-checked is a truth state that varies.

check requesting the score:
	say "You're in the [mrlp] sector. You have scored [score] out of [maximum score] points so far.";
	if purposes cross is visited:
		if way-out bluff is unvisited:
			say "[line break]";
			if things-gone is 3:
				say "You should probably get going past Bull Gully now.";
			else:
				say "You'd like to get past Bull Gully, but it seems [if things-gone is 0]way [else if things-gone is 2]a little [end if]too scary.";
		else:
			if score is 10:
				say "You need to find a way past the grate.";
			else if score is 11:
				say "The Bare Cave must have a way out.";
	the rule succeeds;

to say alec-mood:
	if map region of location of alec is preamble:
		say "Wandering";
	else:
		say "adventuring";

to say up-right:
	say "[score]/[maximum score]";

book waiting

check waiting:
	if Alec is in that thought park:
		say "You feel restless. Like you need to go...any which way." instead;
	say "[one of][activation of nothing doing]Doing nothing? Nothing doing![or][activation of bust a move]Move? A bust![in random order]" instead;

book sleeping

the block sleeping rule is not listed in any rulebook.

instead of sleeping:
	if map region of location of alec is preamble:
		say "You could get picked up by police for that.";
	else if Alec is in cadet space:
		say "You couldn't decide which cot to sleep on, and the Change Chump would distract you anyway.";
	else:
		say "You don't need to."

book jumping

the block jumping rule is not listed in any rulebook.

check jumping:
	if Alec is in purposes cross:
		say "The terminal can help you jump, but not over Bull Gully." instead;
	if Alec is in bluff:
		if grate is in bluff:
			say "The grate is too high." instead;
	say "No need for a big jump. Well, a physical jump." instead;

volume irregular verbs

chapter touchcommoning

touchcommoning is an action applying to nothing.

understand the command "touch common" as something new.

understand "touch common" as touchcommoning.

carry out touchcommoning:
	if crossed is true:
		say "'[activation of double take]TAKE DOUBLE?!' booms a voice. You flinch, recalling that time a grocery store employee caught you reading MAD magazine.[paragraph break]You got enough of a jump. No sense getting greedy." instead;
	if cadet space is visited:
		say "You need to be in Green Monde (before Cadet Space) to run the Touch Common command." instead;
	say "(jumping to before you choose what to take in the Delta. Type UNDO to reverse this.)[paragraph break]";
	move Alec to sense common;
	increase the score by 4;
	now wait paper is in lalaland;
	now Alec has tiger paper;
	now effort token is in lalaland;
	now furniture of peace is in lalaland;
	now crossed is true;
	ital-say "if you used this warp command by mistake, you can UNDO.";
	the rule succeeds;

chapter crossdoubleing

crossdoubleing is an action applying to nothing.

understand the command "cross double" as something new.
understand the command "cd" as something new.

understand "cross double" as crossdoubleing.
understand "cd" as crossdoubleing.

crossed is a truth state that varies.

carry out crossdoubleing:
	if crossed is true:
		say "'[activation of double take]TAKE DOUBLE?!' booms a voice. You flinch, recalling that time a grocery store employee caught you reading MAD magazine.[paragraph break]You got enough of a jump. No sense getting greedy." instead;
	if map region of location of alec is not preamble:
		say "You are too far along. You need to restart the game for this jump command to work." instead;
	while player is not in purposes cross:
		say "[one of]OK, which item do you want? [or][line break]No wrong answers. X cancels this jump. [stopping](B=bottle, J=jar, S=solution, N=none, X=exit) ";
		let cholet be the chosen letter;
		if cholet is 66 or cholet is 98:
			now Alec has bottle;
			move Alec to purposes cross;
		if cholet is 74 or cholet is 106:
			now Alec has jars;
			move Alec to purposes cross;
		if cholet is 78 or cholet is 110:
			say "OK, you can go back to the Delta when you decide what you want.";
			move Alec to purposes cross;
		if cholet is 83 or cholet is 115:
			now Alec has solution;
			move Alec to purposes cross;
		if cholet is 88 or cholet is 120:
			say "OK, backing out.";
			the rule succeeds;
	now crossed is true;
	the rule succeeds;

chapter using

useoning it with is an action applying to two things.

understand the command "use" as something new.
understand "use [something] on [something]" as useoning it with.
understand "use [something] with [something]" as useoning it with.

does the player mean useoning with a tripuzzly thing: it is likely.

rule for supplying a missing second noun while useoning with:
	if player is in cadet space:
		if noun is scenery and noun is not pocket:
			try sleeping instead;

does the player mean useoning with alec: it is very unlikely.

does the player mean useoning with the rate coop: it is likely.

does the player mean useoning with noun: it is unlikely.

does the player mean useoning with a propagandy thing: it is likely.

does the player mean useoning coop with wait paper: it is likely.
does the player mean useoning coop with tiger paper: it is likely.

check useoning it with:
	if noun is second noun:
		say "Using something on itself doesn't work, backwards or forwards." instead;
	if second noun is gully:
		if score is 9:
			say "You're not scared of the gully any more." instead;
		else:
			say "You'll have to work on your own fears to get by that.";
	if noun is away forge or second noun is away forge:
		say "The forge is out of commission." instead;
	if second noun is right knot:
		try useoning noun with neutrality net;
	if noun is right knot:
		try useoning second noun with neutrality net;
	if noun is head forge or second noun is head forge:
		if noun is wait paper or second noun is wait paper or noun is tiger paper or second noun is tiger paper:
			say "The best way seems to be to enter the forge.";
			try entering the head forge;
			the rule succeeds;
	if noun is alec or second noun is alec:
		say "You don't need to mess with yourself at all." instead;
	if second noun is terminal or noun is terminal:
		say "The terminal is relatively harmless. Besides, any pyrotechnics would be not as practical as you hoped. Of course." instead;
	if noun is scenery in cadet space and noun is not pocket:
		try sleeping instead;
	if noun is token and second noun is chump:
		try giving noun to chump instead;
	if noun is sensor or second noun is sensor:
		say "The sensor just reports what's there. Or isn't." instead;
	if noun is token and second noun is pocket:
		try inserting token into pocket instead;
	if noun is wait paper and second noun is rate coop:
		say "The--well, a--rate coop grinds and pauses for a bit. 'How-do-you-keep-an-undesirable-in-suspense.' It spits back the wait paper after a couple minutes.[paragraph break]Well, at least it didn't become an irate coop." instead;
	if noun is bottle:
		if number of things contained in bottle is 1:
			try useoning random thing contained in bottle with second noun instead;
	repeat through table of useons:
		if there is a use1 entry and noun is use1 entry:
			if there is a use2 entry and second noun is use2 entry:
				if there is a getit entry:
					if getit entry is guzzler gas or getit entry is bawl slime:
						now getit entry is in bottle of bottle;
					else if there is a getit entry:
						now Alec has getit entry;
				if noun is tiger paper and second noun is rate coop:
					now tiger paper is in lalaland;
				if disappear entry is true:
					now use2 entry is in lalaland;
				say "[babble entry][line break]";
				if sco entry is true:
					now use1 entry is in lalaland;
					see-alec-improve;
				the rule succeeds;
			else if there is no use2 entry:
				say "[babble entry][line break]";
				the rule succeeds;
		if there is a use2 entry and second noun is use2 entry and there is no use1 entry:
			say "[babble entry][line break]";
			the rule succeeds;
		if there is a use1 entry and second noun is use1 entry:
			if there is a use2 entry and noun is use2 entry:
				try useoning second noun with noun;
				the rule succeeds;
	if noun is firstpuzzly:
		say "Hm. It's not something you can really use. It's more like a security blanket that makes you feel cleverer and braver in its own way." instead;
	if noun is token and second noun is scenery:
		say "You doubt you could bounce a quarter off any of the sheets, and if you did, it's probably get lost again." instead;
	say "You think of ways to do that productively, but nothing comes up." instead;

to see-alec-improve:
	increment the score;
	if score > 6:
		say "Well, now that that's gone, you believe in yourself a bit more now. You bet the Town Ghost does, too."
		
table of useons
use1	use2	getit	sco	disappear	babble
bottle	ship sensor	--	false	false	"No, you can't it the ship sensor in the bottle. How DO they do that, anyway?"
tiger paper	rate coop	--	true	false	"The rate coop coughs and wheezes for thirty seconds before belting out a tinny 'APPROVED.'"
context device	charming prints	proof bullet	true	true	"The context device begins beeping and sorting out the charm prints. Suddenly, they're not so charming any more. You see that they only apply in certain cases. As the prints crumble, you see a bullet--a proof bullet--behind it."
context device	neutrality net	--	false	false	"It seems like it should work. But the neutrality net is a bit too strong. Perhaps the context device can be used against something a little less robust."
context device	homonym ad	--	false	false	"Unfortunately, the context of the homonym ad doesn't really change from 'BUY STUFF.'"
context device	--	--	false	false	"The device doesn't change anything here."
proof bullet	neutrality net	light engine	true	true	"You drop the bullet into the neutrality net. One strand fizzles, then another, Soon, the whole net collapses. You see what's behind it: a surprisingly light engine! You pick it up, expecting not to budge it, and it--well, you pick it up easily."
proof bullet	homonym ad	--	false	false	"Well, ads are ads. They don't need to be shot down, just ignored."
proof bullet	--	--	false	false	"The proof bullet doesn't do enough damage, here."
light engine	erotic auto	--	true	true	"You don't know much about cars, but you do know where the engine is. You slip the old engine out and put the new one in. Someone comes along to give it a spin. 'Oh, man! It's even sleeker now!' They don't even remember to put their seat belt on the cad, but when they are out of sight past Production Peak, you hear a crash, then cursing over what a piece of junk the auto was, dang near combusting on hitting a stop sign.[paragraph break]You register the important, if a bit heavy-handed, lesson of not being too dazzled by cutting-edge technology."
light engine	--	--	false	false	"The light engine probably needs to be part of a machine."
under buckle	erotic auto	upright bolt	true	true	"The under buckle fits, well, under the auto. It begins to shake. The auto falls apart! People crowd around and blame you before you finally explain to them that if something that weak could tear up the auto, it might actually hurt someone. They weigh blaming one techie dork versus blaming several for an unsafe product, and they settle on several."
under buckle	--	--	false	false	"Nothing the right size to slip the buckle under, here. It can expand to about five feet wide."
upright bolt	charming prints	worm hook	true	true	"The upright bolt creates one ripple through the prints, then another. After a while, you see cracks in the prints. Too-flowery words change from happy to sad to profanity to nonsense."
upright bolt	--	--	false	false	"The upright bolt doesn't fit anywhere here. It looks like it could spike something pretty good, though."
worm hook	neutrality net	--	true	true	"The worm hook slips onto the neutrality net and greases up some of the knots. Then they begin to fray, then collapse. Nothing is left behind."
worm hook	--	--	false	false	"The worm hook can't vandalize anything here."
poker strip	neutrality net	guzzler gas	true	true	"You poke at the neutrality net, and some of its knots come loose. Then a few more. Then it dissolves. Some gas blurps out of where the net was--then, well, gasoline. You collect as much as you can in your bottle."
poker strip	--	--	false	false	"The poker strip fails to poke sufficiently annoyingly."
guzzler gas	erotic auto	bawl slime	true	true	"You pour the guzzler gas into the erotic auto, which starts coughing and sputtering and wheezing. It begins to drip...drip...and you collect the slime that falls from it in your bottle."
guzzler gas	charming prints	--	false	false	"The prints are full of gas enough as it is."
guzzler gas	--	--	false	false	"That doesn't need gas."
bawl slime	charming prints	--	true	true	"The bawl slime takes naturally to the charming prints, which dissolve into profanities and such before disappearing completely."
bawl slime	--	--	false	false	"That'd get things icky to no purpose."
--	homonym ad	--	false	false	"The homonym ad continues blinking away."
--	picker rag	--	false	false	"Nothing happens to the picker rag."
--	notes bank	--	false	false	"Nothing happens to the notes bank."

chapter hinting

hinting is an action applying to nothing.

understand the command "hint" as something new.

understand "hint" as hinting.

hinted-yet is a truth state that varies.

carry out hinting:
	if hinted-yet is false:
		say "'[activation of rubbish tip]Tip? Rubbish!' you hear a voice. Yup, it's the [bad-guy-pc]. You hear him saying he's sure you have some sneaky way to get other hints, then some arglebargle about the journey being important--well, for less directly important people like you.[line break]";
		ital-say "Slicker City should come with InvisiClues-style HTML, as well as a PDF map created in Trizbort and a regular text walkthrough. There are even test walkthrough runs in the source provided. So you should be okay.";
		now hinted-yet is true;
	else:
		say "The game should come with several types of hints/feelies. If you're curious about the meaning of some of the phrases, you can XP an object or a phrase.";
	the rule succeeds;

chapter reading

reading is an action applying to one thing.

understand the command "read" as something new.

understand "read [something]" as reading.

read-warn is a truth state that varies.

carry out reading:
	if read-warn is false:
		say "(NOTE: READ is equivalent to EXAMINE, or, quicker, X.)[paragraph break]";
		now read-warn is true;
	try examining the noun instead;
	the rule succeeds.

volume parser errors and operations

part reading a command

in-beta is a truth state that varies.

after reading a command:
	if the player's command matches the regular expression "baiter|master|messiah|complex":
		say "It's tough not to think of him, especially when you say you're not going to think of him. But just doing so freezes you up. Even if you can't see him anywhere. You've had imaginary conversations with him, and you don't lose all the time, but--aigh." instead;
	if the player's command matches the regular expression "^\p" or the player's command matches the regular expression "^<#\*;>":
		if currently transcripting:
			say "(Noted.)";
			reject the player's command;
		if in-beta is true:
			say "It looks like you tried to leave a comment, but you didn't have transcripting on. So, just in case, TRANSCRIPT may turn it on.";
			reject the player's command;
	if Alec is in bare cave:
		if the player's command matches the regular expression "^(0|1|2|3|4|5|6|7|8|9|10)<a-z>$":
			let N be indexed text;
			let N be the player's command;
			replace the regular expression "(<a-z>)((0|1|2|3|4|5|6|7|8|9|10)+)$" in N with "\2\1";
			replace the regular expression "^" in N with "push ";
			change the text of the player's command to N;
		else if the player's command matches the regular expression "<a-z>(0|1|2|3|4|5|6|7|8|9|10)+$":
			let N be indexed text;
			let N be the player's command;
			unless the player's command matches the text " ":
				now N is "push [N]";
			replace the regular expression "(<a-z>)((0|1|2|3|4|5|6|7|8|9|10)+)$" in N with "\2\1";
			change the text of the player's command to N;
			say "(Reversing)[paragraph break]";
	if Alec is in way-out bluff and mind grate is in way-out bluff:
		if the player's command includes "great":
			say "You may have to DO something great, but you have to do it to the grate.";
			reject the player's command;
		if the player's command includes "grate":
			if word number 1 in the player's command is "grate" or word number 2 in the player's command is "great":
				now word-req is 2;
			else:
				now word-req is 1;
			now one-word is false;
			try-grate-poss;
			reject the player's command;
		else if number of words in the player's command is 1:
			now one-word is true;
			now word-req is 1;
			try-grate-poss;

one-word is a truth state that varies.

word-req is a number that varies.

to try-grate-poss:
	repeat through table of grate tries:
		if word number word-req in the player's command is wordtry entry:
			if there is a winner entry and winner entry is true:
				if word-req is 2:
					say "Close! Very.";
					consider the grate clue rule;
					continue the action;
				say "[tryresp entry][line break]";
				increment the score;
				now did entry is true;
				consider the notify score changes rule;
				now mind grate is in lalaland;
				continue the action;
			now did entry is true;
			say "[tryresp entry][line break]";
			consider the grate clue rule;
			continue the action;
	if one-word is false:
		say "You look at the grate, hoping it will change, but nothing happens. Maybe another word, some decisive action. Maybe a bit creative. Nothing too brute force.";
		consider the grate clue rule;

table of grate tries [tgt]
wordtry	winner	did	tryresp
"deal"	true	false	"You've got the way to dispel the grate. You don't have the details, but...as you go up and start to poke at it, it dissolves."
"demand"	true	false	"You've got a big argument wound up about how the grate doesn't need to stand there, and you'd find away around it anyway. But it shimmers and vanishes before you get started."
"divide"	true	false	"You wind up for a big fake karate chop, thinking of leverage and pressure points without really thinking of them. Bam!"
"escape"	true	false	"You whistle an old marching tune you learned from somewhere, and you ignore the mind grate--until it wobbles, blurs and falls apart."
"experience"	true	false	"You attempt to become one with the grate, its troubles, and worries. In doing so, you somehow manage to let it into your subconscious, and it realizes you have places to go. Well, a place. The cave behind it. It dissolves."
"game"	true	false	"You aren't sure how, and it probably wouldn't work if you thought too hard about it, but you manage to convince yourself that the grate is not so hot, or sturdy, or intimidating. It crumbles from your psychic assault."
"question"	true	false	"You regale the grate with deep questions. Why are we here? And so forth? Somehow, it works."
"race"	true	false	"You crouch down, ready to sprint. You begin running back and forth. You're not especially fast, but somehow you make the grate jealous you can run and it can't."
"shake"	true	false	"You give the grate a good rattle, and surprisingly, it falls over and allows you passage inside."
"stuff"	true	false	"You start stuffing whatever dirt you can find into the grate. It proceeds to get stuffed, literally, then figuratively! It vanishes in a burst of energy."
"weigh"	true	false	"You calculate the grate's spiritual and physical weight. It's not such a big deal. It seems to recognize this as you calculate further. Slowly, it shimmers and dissolves."
"gatsby"	false	false	"'Nice try, old sport,' the grate seems to mock you."
"mind"	false	false	"No, that's the problem. You're minding it too much. Think of a way to dispose of it."
"great"	false	false	"Oh, it's not THAT great."
"beyond"	false	false	"No, you need to get beyond, but you can't quite teleport. You need to defeat the grate."
"love"	false	false	"You can't bring yourself to love an inanimate object. That's a bit too hokey. But maybe you can do something with it."
"deny"	false	false	"That's a bit TOO direct."
"coat"	false	false	"Nothing to coat it with."
"get"	false	false	"It can't be that easy."
"take"	false	false	"It can't be that easy."
"move"	false	false	"It can't be that easy."
"full"	false	false	"You need to DO something to the grate. And making it full would make it harder to pass, anyway."
"find"	false	false	"You've already found it."
"fined"	false	false	"If the grate had financial worries, that might work. But it doesn't."
"clips"	false	false	"Alas, no hair-cutting salon appears."
[?? can always use more clues]

every turn when Alec is in way-out bluff and mind grate is in way-out bluff (this is the grate clue rule):
	the rule succeeds;

volume explaining

explaining is an action applying to one visible thing.

understand the command "explain" as something new.
understand the command "xp" as something new.

understand the command "explain [any thing]" as something new.
understand the command "xp [any thing]" as something new.

understand "explain [any explainable thing]" as explaining.
understand "xp [any explainable thing]" as explaining.

understand the command "explain [any room]" as something new.
understand the command "xp [any room]" as something new.

understand "explain [any xpable room]" as explaining.
understand "xp [any xpable room]" as explaining.

expl-hint is a truth state that varies.

told-xpoff is a truth state that varies.

carry out explaining:
	d "Explaining a [if noun is a room]room[else]thing[end if].";
	let found-yet be false;
	let myt be table of explanations;
	if noun is a room:
		now myt is table of room explanations;
[	if noun is an exp-thing listed in myt:
		if anno-allow is true and told-xpoff is false:
			now told-xpoff is true;
		if anno-allow is false or no-basic-anno is false:
			say "[exp-text entry][line break]";
		now found-yet is true;]
	if noun provides the property unflip and noun is unflip:
		say "Nothing special or tricky or annotate-able about that." instead;
	repeat through myt:
		if noun is exp-thing entry:
			if anno-allow is true and told-xpoff is false:
				now told-xpoff is true;
			if anno-allow is false or no-basic-anno is false:
				say "[exp-text entry][line break]";
			now found-yet is true;
	if found-yet is false:
		say "There should be an explanation, but there isn't.";
		the rule succeeds;
	choose row with exp-thing of noun in myt;
	the rule succeeds.

understand "explain [text]" as a mistake ("You've come across nothing like that, yet. Or perhaps it is way in the past by now.")

table of explanations [things] [alfbyroom]
exp-thing	exp-text
a thing	"A smart alec(k) is someone who always has something clever to say." [start general]
Change Chump	"Chump change is a negligible amount of money." [start cadet space]
cold cot	"Caught cold means exposed, or caught in the act."
cots mass	"Mascots are good-luck objects or living things, often for a sports team."
napping cot	"Caught napping means literally caught sleeping, or not paying attention."
off-balance cot	"Caught off-balance means caught at an awkward time."
short cot	"Caught short means not having enough energy or ability to do something."
ton cot	"Cotton is not particularly heavy. A bed wouldn't weigh a ton."
up cot	"Caught up means either up to date or stuck on a certain task."
effort token	"A token effort is doing only the minimum and not really trying."
Furniture of Peace	"A piece of furniture is, well, just furniture."
protector pocket	"A pocket protector is looked on as something rather uncool to wear. It is used to prevent pens['] ink from spilling."
away forge	"To forge away is to keep working at something. As opposed to the now out of commission forge."
a head forge	"To forge ahead is to keep working, often against ridiculous odds."
Solution of Solution	"A solution is a way to figure something out, or it is any chemical compound." [start delta of delta]
A Rate Coop	"There's a bit of slick pronunciation here, but to cooperate is to work together. The (a) rate coop forces you to have the right documentation, and it doesn't give hints."
Jars of Jars	"A jar is a glass container, or to jar something it to shake it physically or mentally."
Bottle of Bottle	"A bottle is used to store liquid, or bottle is bravery. Bottling something can also mean messing it up." [start purposes cross]
Bull Gully	"Gullible means believing everything that you're told, or easily suckered"
disappointment terminal	"Terminal disappointment is never finding anything to be satisfying."
p-c	"Cross purposes are goals that contradict each other."
crasher gate	"The crasher gate is a security measure against people looking to infiltrate, but a gate crasher is an uninvited or unpaying guest."
Player Roll	"A player roll is a list of people willing to play the losing game of Lent-You-Corp. A role player is someone who is sort of in the background."
Erotic Auto	"Autoerotic means sexually self-stimulating." [start of profit turn]
Homonym Ad	"Ad hominem means attacking the person and not their logic or arguments." [start Production Peak]
Charming Prints	"Prince Charming is a perfect romantic partner, almost too good to be true." [start Way of Right]
Notes Bank	"Bank notes are, well, paper currency like dollar bills." [start ArtistCon]
Mind Grate	"A great mind is something with all the answers, especially to help others understand things." [start Way-Out Bluff]
Neutrality Net	"Net Neutrality is a concept that all Internet data should be treated the same by government regulations. The Neutrality Net traps people into 'being objective' by considering the feelings of more aggressive people." [start Jungle of Law]
Picker Rag	"A ragpicker is a poor person who makes a living digging through trash. A rag is a cheap magazine, and a 'picker' is someone who picks at others['] faults."
tiger paper	"A paper tiger is someone who seems to be powerful or strong but can be taken down by simple means."
wait paper	"A paperweight is used to hold papers down. A wait paper, well, tells people to wait."
bawl slime	"A slimeball is a person who uses dirty tricks to win arguments or get ahead."
bolt upright	"Bolt upright means standing stiffly."
proof bullet	"Bulletproof means literally undamageable by bullets, or just hard to discredit."
worm hook	"A hookworm is a parasite that causes intestinal diseases."
light engine	"An engine light usually says something is wrong with an engine."
guzzler gas	"A gas guzzler is a vehicle larger than it needs to be that uses more gas than it should."
poker strip	"Strip poker is a game where the loser of each hand takes off an article of clothing."
context device	"A device context is a technical computer term for where you can dump graphics you don't yet want to print to a screen."
under buckle	"To buckle under is to give in."
Snowflake Special	"Special Snowflake is what people can call someone if that person asks for help, as if to say, what makes you think you deserve extra positive attention? The connotation is a bit nasty." [start of bare cave]

table of explanations (continued) [people]
exp-thing	exp-text
Kay Riss	"Risque means potentially off color, especially for goals."
Terry Common	"Commentary is when someone is discoursing on a subject."
Baiter Master	"A masturbator is someone who, well, commits impure acts on themselves. But a master baiter is someone who gets people to lash out."
Town Ghost	"A ghost town is one without any people left. Slicker City, of course, is going to have a lot more people. Apparently."

table of room explanations [locations] [tra]
room-to-exp	exp-text
That Thought Park	"To park that thought is to ask someone to put their current worry aside."
Cadet Space	"A space cadet is someone who is flaky and misses out on what's happening."
Bees Wood	"Would-bes are what could've happened."
A Feel Copse	"If someone cops a feel, they are touching someone else inappropriately."
Delta of Delta	"A delta is a mathematical symbol for a change, but it is also a place where a river basin expands into the sea."
Sense Common	"Common sense is the ability to know what to do and avoid stupid acts."
Back Quarter	"A quarterback is the most visible and valuable player on an American football team."
Crazy Bureau	"Bureaucracy is a tangle of institutions that may be hard to navigate to get simple things done."
Profit Turn	"To turn a profit means to make money."
Production Peak	"Peak production is making the most that you can. Actually, not much happens in Production 
Peak."
Purposes Cross	"Cross purposes are goals that contradict each other."
Way of Right	"Right of Way decides which pedestrian or vehicle goes first."
Snipe Gutter	"A guttersnipe is a street urchin, but not necessarily one who snipes (takes cheap shots) at other people."
The Jungle of Law	"Law of the Jungle is from Kipling's Jungle Book. It's somewhat fair, and it's pretty simple. The law in SC is more tangled."
Protection Cavity	"Cavity protection is what all toothpaste says it has. But a protection cavity protects you from stuff you don't need to be protected from."
comedy-club	"The comedy club has two names based on if innuendo is on. Cottage cheese is a relatively bland dairy food, while culture shock is being surprised by a new society with different values from your own."
Lent-You-Corp	"Corpulent means fat, as opposed to the 'lean, mean' business Lent-You-Corp claims to be."
ArtistCon	"A con artist is someone who suckers people by gaining their faith and then taking their money. ArtistCon is simply an assembly of people who like to make or study art."
Ache Mist	"A mistake is, well, something you did wrong."
Old Mist	"Mistold means someone said something to you that was wrong."
Eerie Mist	"Mystery. Stuff that confuses you."
Rust Mist	"Mistrust. Not being able to believe what others say."
Bare Cave	"A bare cave is nothing to be afraid of, unless a big scary Cave Bear is hiding out of sight."
Way-Out Bluff	"To bluff your way out is to extract yourself from a tricky situation by using your wits. But Way-Out Bluff is just far from Slicker City."

table of explanations (continued) [this is stuff referred to tangentially, concepts but not actually objects in the game] [xxadd]
exp-thing	exp-text
bust a move	"To bust a move is to dance creatively and energetically. 'Move? A bust' means apathy." [start generic commands]
fine tuning	"fine tuning is when you make tiny fixes to something that's just about ready."
lame duck	"A lame duck is a politician who is in their last elected term. They have the ability to be bold, or they can do nothing. Here, it just means, duck a lame swear."
not your type	"'Not your type' means someone or something you're not attracted to. The reverse means, well, you didn't type anything."
nothing doing	"Nothing doing means, that doesn't work, to something someone says or does."
rubbish tip	"A rubbish tip is a garbage bin."
type o negative	"Type O Negative is a blood type."
type o positive	"Type O Positive is a blood type."
double take	"A double take is a surprised reaction."
whale of a time	"A whale of a time is a great time, the opposite of time of a wail (complaining)."
mondegreen	"A mondegreen is lyrics misheard as something else that's plausible or funny." [start main stuff]
Slicker City	"A city slicker is someone who is a bit too clever for their own good. Slicker City 'helps' people become slicker."
two-bit	"Two-bit means very cheap. Literally, two bits is a quarter. But no, there won't be eight installments in this series."
rigidly	"Rigidly means fixed in your views." [start of That Thought Park]
augment	"To augment is to add meaningfully to something, the opposite of your verbal stumbling."
banality of evil	"The banality of evil is a term coined by Hannah Arendt about how nastiness can be concealed in ordinary everyday things. The evil of banality--well, advertising scares us into thinking being ordinary, or pleased with non-exciting stuff, is a bad thing." [start of A Feel Copse]
figurehead	"A figurehead is someone with an important title who doesn't really have any power."
forbidden	"Bidden-for means you are called. Forbidden means you're not allowed at all."
stunt double	"A double stunt is doing the same thing again. A stunt double is someone who does stunts an actor can't do for themselves in a movie."
token of appreciation	"A token of appreciation is a small thing someone gives to say thank you." [start cadet space]
token resistance	"Token resistance is not trying very hard to stop something."
town square	"Town/Village Square usually means the center where everyone gets together, listens to proclamations, etc."
check in	"Check in is when you make sure someone's okay. To keep them in check is to make sure they're not doing anything you don't want them to." [start sense common]
ship sensor	"Censorship is quieting people so that they do not speak out. In this case, the ship sensor is trying to make Alec give up."
backstab	"To backstab is to betray someone who trusted you." [start Crazy Bureau]
gullible	"Gullible means suckered easily. Bull also has the connotation of nonsense, as in Bull (expletive)." [start purposes cross]
wit staircase	"Staircase wit is when you think of a joke a second too late." [start of comedy-club] [partnership]
comedy club	"A comedy club is where people stand on stage and tell jokes. Club comedy directs what sort of jokes--at the expense of others."
zeho	"Zero hour means the time of a big confrontation." [start of snipe gutter]
sober	"Sober means not having any alcohol in you." [start of Lent-You-Corp]
business instinct	"Business instinct is having an intuitive idea how to make a profit or gain customers. The opposite, the instinct business, refers in this case to ethical opposition to unfair profits." [start of profit turn]
claptrap	"Claptrap means nonsense." [start of production peak]
nuance	"Nuance is finding meaning in details that can often help you see the big picture as it really should be." [start of Jungle of Law]
point of no return	"The point of no return is something you can't go back from. The return of no point means you no longer have anything meaningful to do." [start of way-out bluff]
panelist	"A panelist is someone who makes comments on various issues to an audience." [start of bare cave]
panic button	"The panic button is what you push when you don't know what to do."
people pod	"Pod people are aliens. The people pod, well, helps you get back to other people, eventually."

does the player mean explaining Alec Smart:
	it is likely;

carry out explaining Alec Smart:
	let count be 0;
	if debug-state is true:
		now all rooms are visited;
		let count be 0;
		repeat with Q running through explainable people:
			if Q is not an exp-thing listed in table of explanations and Q is not unflip:
				if count is 0:
					say "====Unexplained people====[line break]";
				increment count;
				say "[count]: [Q][if Q is privately-named](privately-named)[end if] ([location of Q]) needs an explanation.";
		if count is 0:
			d "YAY! All people covered!";
		let count be 0;
		repeat with Q running through explainable things:
			if Q is not a person:
				if Q is not an exp-thing listed in table of explanations and Q is not unflip:
					if count is 0:
						say "====Unexplained things====[line break]";
					increment count;
					say "[count]: [Q][if Q is privately-named](privately-named)[end if] ([location of Q]) needs an explanation.";
		if count is 0:
			d "Yay! No unexplained things.";
		now count is 0;
		repeat with Q running through rooms not in inaccessible:
			if Q is not an room-to-exp listed in table of room explanations:
				if count is 0:
					say "====Unexplained rooms====[line break]";
				increment count;
				say "[count]: [Q][if Q is privately-named](privately-named)[end if] ([location of Q]) needs an explanation.";
			else:
				unless there is an exp-text corresponding to a room-to-exp of Q in table of room explanations:
					increment count;
					say "[count]: [Q][if Q is privately-named](privately-named)[end if] ([location of Q]) is in the table but needs an explanation.";
		if count is 0:
			d "Yay! No unexplained rooms.";
		unless the player's command includes "me":
			the rule succeeds;

definition: a thing (called x) is explainable:
	if x is in lalaland, decide yes;
	if location of x is visited, decide yes;
	if Alec carries x, decide yes;
	if x is Baiter Master, decide yes;
	if x is Town Ghost, decide yes;
	if x is off-stage, decide yes;
	decide no;

definition: a room (called r) is xpable:
	if r is visited, decide yes;
	decide no;

chapter xpoffing

xpoffing is an action out of world.

understand the command "xpoff" as something new.

understand "xpoff" as xpoffing when ever-anno is true.

no-basic-anno is a truth state that varies.

carry out xpoffing:
	now told-xpoff is true;
	now no-basic-anno is whether or not no-basic-anno is true;
	say "Basic explanations now [if no-basic-anno is true]don't [end if]appear with annotations.";
	the rule succeeds;

volume Preamble Region

Alec Smart is a person. the player is Alec Smart.

description of Alec Smart is "You're not in bad shape, really. Over the years 'I like what's inside of me' no longer feels like a cop-out, and you know you're not wonderful looking, but you don't worry you're worse looking than everyone else. Well, not that much."

skip-baiter is a truth state that varies.

There is a region called Preamble.

a direction has a number called rotation. the rotation of a direction is usually -1.

the rotation of north is 0.
the rotation of northeast is 1.
the rotation of east is 2.
the rotation of southeast is 3.
the rotation of south is 4.
the rotation of southwest is 5.
the rotation of west is 6.
the rotation of northwest is 7.

last-intro-dir is a direction that varies.

to decide what number is the bendiness of (d1 - a direction) and (d2 - a direction):
	let b be the rotation of d1 - the rotation of d2;
	if b < 0:
		now b is 0 - b;
	if b > 4:
		now b is 8 - b;
	decide on b.

to decide what number is clock-rot of (d1 - a direction) and (d2 - a direction):
	let b be rotation of d2 - rotation of d1;
	if b < 0:
		now b is b + 8;
	decide on b;

That Thought Park is a room in preamble. "You've been to places like this before. It's fun to stay, but you also need to move on to keep ideas flowing. And you can, any which way, and not be too lost, or too found."

the trees are unflip scenery in That Thought Park. "You're not a botanist, so you don't know any details, but they're nice to have around."

instead of doing something with trees:
	if current action is climbing:
		say "Dangerous, at night, and with nobody around. Besides, they're pretty tall!" instead;
	if current action is examining:
		continue the action;
	say "The trees are just there and insulation against the city. You don't need to do anything with them."

Alec Smart is in Thought Park.

first-turn is a number that varies. second-turn is a number that varies.

before going when mrlp is preamble: [That Thought Park, Bees Wood, A Feel Copse]
	if noun is up:
		say "You could climb a tree, but now that you're big and strong enough to climb, none have big enough branches to support your weight." instead;
	if noun is down:
		say "There are no tunnels or anything, here." instead;
	if rotation of noun is -1:
		say "You need an actual compass direction, here. There doesn't appear to be any wrong choice." instead;
	if Alec is in that thought park:
		now last-intro-dir is noun;
		move Alec to Bees Wood instead; [That Thought Park]
	path-remark bendiness of noun and last-intro-dir;
	if Alec is in Bees Wood:
		now first-turn is clock-rot of noun and last-intro-dir;
	else:
		now second-turn is clock-rot of noun and last-intro-dir;
	if Alec is in Bees Wood: [Bees Wood]
		now last-intro-dir is noun;
		move Alec to A Feel Copse instead;
	d "first-turn is [first-turn] and second-turn is [second-turn].";
	if first-turn is 4 or second-turn is 4:
		d "reversal";
		say "A familiar voice asks, 'Wandering back and forth a bit, eh?'";
	else:
		let found-rotation be false;
		repeat through table of rotation responses:
			if got-rot-match of rot-first entry and rot-second entry:
				d "[rot-first entry]-[rot-second entry]."; [ this is so the regression test checks we have the right row]
				now found-rotation is true;
				if there is a bg-blurb entry:
					say "[line break][bg-blurb entry][line break]";
				else:
					say "BUG. There should be an entry, but there isn't.";
				break;
		unless found-rotation is true:
			say "Oops. There should be an entry mapping to [first-turn], [second-turn], but there isn't.";
	follow the meet-the-master rule;
	if the rule succeeded:
		move Alec to cadet space instead;
	else:
		end the story saying "Home Run? Run Home!";

to decide whether got-rot-match of (fir - a number) and (sec - a number):
	if fir is first-turn and sec is second-turn:
		decide yes;
	if fir is second-turn and sec is first-turn:
		decide yes;
	if fir is 8 - first-turn and sec is 8 - second-turn:
		decide yes;
	if fir is 8 - second-turn and sec is 8 - first-turn:
		decide yes;
	if fir is 0 and first-turn is 0:
		if sec is second-turn or sec is 8 - second-turn:
			decide yes;
	if fir is 0 and second-turn is 0:
		if sec is first-turn or sec is 8 - first-turn:
			decide yes;
	decide no;

Bees Wood is a room in preamble. "You hear the drone of bees. They don't scare you as much as they used to. One stung you, and it wasn't the end of the world. You learned to stand still without freezing up, but when you said there was a deeper lesson, someone laughed at you. You wonder now how you could've held your ground a bit better, or if you'll get the chance again."

bz are unflip privately-named plural-named scenery in bees wood. understand "bees" as bz when Alec is in bees wood. description is "BUG". printed name of bz is "bees".

instead of doing something with bz:
	say "The bees are there and nocturnal, but you can't see them."

The room called A Feel Copse is in preamble. "This looks like the sort of place where couples go to make out. Big grown-up high school couples, you once thought. But you're in college now and know they usually embellished the fun times here."

to path-remark (dn - a number):
	if dn is 0:
		say "You keep on. You'll stumble along somewhere familiar.";
	if dn is 1:
		say "You bend a bit.";
	if dn is 2:
		say "You take a right turn.";
	if dn is 3:
		say "You turn almost fully around.";
	if dn is 4:
		say "You do an about-face. Maybe there was a clue behind you you missed.";

table of rotation responses
rot-first	rot-second	bg-blurb
0	0	"'Going straight, eh? Surprised you didn't run out into traffic by now.'" [n n n]
0	1	"'You were veering a bit, there. That's what happens.'" [n n ne]
0	2	"'Taking a fork, eh?'" [n n e]
0	3	"'Not quite a u-turn, there. Where ARE you going?'" [n n se]
1	1	"'Gonna take a while to circle around, there.'" [n ne e]
1	2	"'Spiraling around?'" [n ne se]
1	3	"'About to make a diamond, there?'" [n ne s]
1	5	"'Could've saved time just walking straight in the first place.'" [n ne w]
1	6	"'Could've saved time just walking straight in the first place.'" [n ne nw]
1	7	"'A small zigzag, there?'" [n ne n]
2	2	"'Three-fourths of a square.'" [n e s]
2	3	"'Triangulating? Well, you'd never make it as a politician.'" [n e sw]
2	5	"'Could've saved time just walking straight in the first place.'" [n e nw]
2	6	"'Just like wandering down city blocks with all those right turns.'" [n e n]
3	3	"'Reliving past glories, eh? With the Thoughts Idol? You do need to move on!'" [n se w]
3	5	"'Wow! A big ol['] zigzag!'" [n se n]

this is the meet-the-master rule:
	say "Wait. That voice wasn't in your head!";
	wfak;
	say "[line break]It's the [bad-guy-pc]! He walks over and shakes your hand. 'Not bad, what you did a few years ago. My heart wasn't in it by the end, but still, good job, I guess. I got over your little break-in a long time ago, so it's all good. Did all that help you, like, cope and stuff?'";
	wfak;
	say "[line break]He wasn't expecting an answer. But you knew that, and you've managed to anticipate that sort of thing without being defensive. But then comes the doozy: 'Yeah. There's somewhere else to be [']saved.['] But, y'know, you already had your chance? Let someone else? I mean, you're smart and all, but you're not THAT special. That deal in the Problems Compound...it should've had enough lessons to last. Shouldn't you let someone else have a chance instead...?' (answer yes or no)";
	let br be 0;
	if debug-state is true:
		now br is 0;
	else:
		now br is baiter-result;
	unless br is 0:
		say "[line break][if br is 2]You shrug silently and walk away[else]Whatever it is, yeah, you don't want to get greedy[end if]. As you retreat, you hear the [bad-guy-pc] say 'You! What makes you think you're qualified to poke around here? Any experience? I didn't think so.'";
		wfak;
		say "[line break]But you're already going back. You get pushed around a bit as an adult, but you know how to deal, and people who get pushed around worse come to you and swear you deserve maybe a bit better than you got. Your motto is, feel grateful despite... and, well, you do feel grateful despite letting the [bad-guy-pc] push you away. It's tough, and you always think, and make good observations, about achievement versus self-promotion. Life is happy enough, and that's more than enough. Or is it?";
		the rule fails;
	else:
		say "[line break]You blow the [bad-guy-pc] off a bit.[paragraph break]'Well, okay,' he says. 'But there's not going to be nearly as much to do this time. Because you have fewer PROBLEMS, amirite? I'll drop you off near [activation of town square]Square Town...wait, no, it'll be Slicker City once we rescued it from the evil of banality[activation of banality of evil]. Go ahead with your [activation of stunt double]double stunt.' You wonder what the catch is.";
	wfak;
	say "[line break]'You see, I'm still a [activation of figurehead]head figure here! If you find a way to ruin things, why, that'll just help me fix what's broke and make the next Square Town work better! So there is really no way to win. Still, what the hell. You don't have anything better to do. But just, even when you win, you lose.' You ask if the Problems Compound was built bigger and better, and why he's not back there.[paragraph break]'Look, you're GETTING the chance to leave your boring little life for a while, cut the wise guy questions, huh?' As he finishes, you're shortly taken from behind and thrown ... somewhere.";
	the rule succeeds;

chapter Introductory Question

to decide what number is baiter-result:
	(- BaiterBlab() -)

Include (-

Array baiterMad --> 4 "~Look, I don't need an essay... yes or no.~" "~Maybe you need to explain yourself, but I have other things to do. Yes or no.~" "~You did all that stuff--whatever it was--but an easy question? Come on, yes or no.~" "~Strong and silent? Well, not really. Just, dude, yes or no.~" "~Great, whatever, dude, I guess you agree.~^";

Array baiterSilent --> 4 "He taps his foot. You should probably answer yes or no." "He throws his hands up in the air." "He makes a pained expression and flips a thumb quickly up or down." "You can't out-silence him. You sort of have to say something." "~Great, whatever, dude, I guess you agree.~^";

[ BaiterBlab i j k;
   k = 0;
   for (::) {
	  if (location ~= nothing && parent(player) ~= nothing) DrawStatusLine();
	  KeyboardPrimitive(buffer, parse);
	  #Ifdef TARGET_ZCODE;
	  j = parse->1;
	  #Ifnot; ! TARGET_GLULX;
	  j = parse-->0;
	  #Endif; ! TARGET_
	  k++;
	  if (j) { ! at least one word entered
		 i = parse-->1;
		 if (i == YES1__WD or YES2__WD) rtrue;
		 if (i == NO1__WD or NO2__WD) rfalse;
		 if (j > 1) { print "~No biographies. Yes or no.~"; }
		 else { print (string) baiterMad-->k; }
	  } else { print (string) baiterSilent-->k; }
	  if (k == 5) return 2;
   }
];

-)

volume Procrastination Region

volume West Procrastination

There is a region called Procrastination.

book Cadet Space

Cadet Space is in Procrastination. "There's not much here in Cadet Space, just a cots mass[if protector pocket is in cadet space]. Well, there's a pocket sewn into the east wall[end if]."

understand "east wall" and "wall" as protector pocket.

instead of climbing scenery when player is in cadet space:
	if noun is protector pocket:
		continue the action;
	try sleeping instead;

cots mass is scenery in Cadet Space. "There are all kinds of cots: a cold cot, a short cot, an up cot, an off-balance cot, a napping cot, and a ton cot (it looks heavy). They don't completely cover the floor. There's space for something, maybe even to give the place some variety."

rand-cot is a thing that varies. [understand "bed/cot" as rand-cot.]

does the player mean useoning with rand-cot: it is very likely.
does the player mean putting on rand-cot: it is very likely.

does the player mean doing something with rand-cot when Alec is in cadet space: it is likely.

cots-searched is a number that varies.

to check-a-cot:
	increment cots-searched;
	if cots-searched is 1:
		say "The Change Chump moans 'Oh, it can't be in there! It's not the first one *I* would have searched. And surely you can't search ALL of them?'";
		continue the action;
	if cots-searched is 2:
		say "The Change Chump moans 'Oh, man, I already searched all of those! It can't be in there. If you find it in the next one, it might make me feel kind of stupid!'";
		continue the action;
	say "You rifle through, and what do you know? A small coin falls out! A closer look reveals it to be an effort token! You take it.";
	now Alec has effort token;
	increment the score;

check examining scenery in cadet space:
	if noun is protector pocket:
		continue the action;
	if noun is cots:
		continue the action;
	if effort token is not off-stage:
		continue the action;
	if noun is not examined:
		now noun is examined;
		check-a-cot;
		pick-default-cot;
		the rule succeeds;
	say "Nope. Still nothing there." instead;

the cold cot is scenery in Cadet Space. "You feel a shiver as you look at it. You're a bit worried the owner might catch you looking at it."

the short cot is scenery in Cadet Space. "You'd hate to be stuck with a cot this short."

the napping cot is scenery in Cadet Space. "The cot looks ideal for napping, but if you slept on it, you'd probably get caught by its owner."

the ton cot is scenery in Cadet Space. "The cot looks hard and soft, heavy and light at the same time. It's in the shape of a very flat one-ton weight like you'd see in a cartoon."

the up cot is scenery in Cadet Space. "You don't know why, but this cot looks particularly ergonomic."

the off-balance cot is scenery in Cadet Space. "You feel wobbly just looking at it."

when play begins:
	pick-default-cot;

to pick-default-cot:
	now rand-cot is random cotty scenery in Cadet Space;
	d "[rand-cot] is new cot to look at.";

definition: a thing (called Q) is cotty:
	if Q is not scenery, no;
	if Q is cots or Q is protector pocket, no;
	if Q is examined, no;
	yes;
[break a cot/unaware cot/frays cot (phrase)/age cot/ton cot/dad cot]

check going nowhere in cadet space:
	say "The only real exit is to the east[if pocket is in cadet space], or if would be, if the protector pocket weren't blocking you[end if]." instead;

The protector pocket is scenery in cadet space. "It reads 'A protector pocket: for protecting the Real World from do-nothing freeloaders. And do-nothing freeloaders from the Real World.' It looks vaguely like a tollbooth basket you remember from family cross-country trips."

check pushing scenery in cadet space:
	if noun is pocket:
		say "You poke it, but nothing happens. It seems more like you need to put something in it." instead;
	else:
		say "The cots are lined up nicely enough. They don't seem to be mobile, anyway."

check taking the pocket:
	say "It's too sturdy to vandalize." instead;

before inserting effort token into protector pocket:
	say "The token drops in easily. The pocket engulfs it, grows, and dissolves. The Change Chump begins whining about how you already paid The Man, which is worse than being paid by The Man, which is worse than paying The Man. He just...can't trust you any more. But you regain some [activation of token of appreciation]appreciation of tokens--you'd almost forgotten how the gesture token helped you get past the Word Weasel, and another one helped again.";
	now protector pocket is in lalaland;
	now effort token is in lalaland;
	increment the score;
	the rule succeeds;

check going east in Cadet Space:
	if effort token is off-stage:
		say "The Change Chump pulls you back. 'You haven't shown me ANY way to change! We--we have to fight together for change.' You sense he's overdoing it." instead;
	else if protector pocket is in cadet space:
		say "You would just run into the protector pocket." instead;
	else if sense common is unvisited:
		say "The Change Chump denounces you as a sell-out for actually wanting to explore, but you've heard enough.";

The Change Chump is a person in Cadet Space. initial appearance is "[if effort token is off-stage][one of]Someone mutters back and forth, pulling his pockets inside out. 'Oh, hi, I'm the Change Chump. I--I'd like change around here, but I know better than to think I can actually get anything done.'[or]The Change Chump continues to look worried and agitated.[stopping][else]The Change Chump continues conspicuously ignoring you.[end if]". description is "Decidedly scruffy, he paces back and forth alternately muttering and yelling against injustice and the impossibility of fixing it."

instead of answering someone that:
	say "NOTE: TALK TO someone is more useful. This game has no detailed dialogue.";
	try talking to the noun instead;

before talking to change chump:
	if effort token is off-stage:
		say "You have nothing to say. You're worried anything you do will be too new or too passe. So you keep quiet. But you remember, for some odd reason, a lucky button on your favorite jean jacket. But it was too warm to wear. Maybe you'll need to find something new.";
	else:
		say "He's shunning you a bit for, apparently, figuring out more than he was able to.";
	the rule succeeds;

check taking scenery in cadet space:
	if noun is pocket:
		say "It's nailed to the wall pretty well." instead;
	if noun is ton cot:
		say "It'd be too heavy even if it werern't nailed to the ground." instead;
	say "The cots are pretty much nailed to the ground." instead;

check entering scenery in cadet space:
	if noun is pocket:
		say "Something smaller could fit in there. Not you." instead;
	else:
		say "You just got here. You're not tired." instead;

every turn when Alec is in Cadet Space:
	if effort token is off-stage:
		say "The Change Chump paces around, searching an imaginary [one of]fireplace[or]umbrella stand[or]wall-closet[or]moving box[in random order].";
	else if a random chance of 1 in 5 succeeds:
		say "The Change Chump marches back and forth, protesting or picketing for some cause or other. You can't lip read.";

check going outside in cadet space:
	try going east instead;

an effort token is a thing. description is "You look at it to see if it's valuable, but you can't decide. It's not worth the bother, really."

understand "coin" as token.

does the player mean useoning token with pocket: it is likely;

book Sense Common

Sense Common is east of Cadet Space. It is in Procrastination. "There are a lot of places to go here, but it seems pretty straightforward what's what, if you think about it. It's pretty open here, but there's something inside to the east. Back west is Cadet Space. You can also go [b]DOWN[r] to [if delta of delta is visited]the Delta of Delta[else]some watery area[end if], or [b]NORTH[r] to [if back quarter is visited]Back Quarter[else]somewhere obscure-looking."

A Head Forge is a fixed in place thing in sense common. "A Head Forge stands here, tall enough to walk into.". description is "It's big enough to enter."

understand "forge ahead" as a mistake ("But how can you use the forge to forge ahead?") when player is in sense common and head forge is in sense common.

the Away Forge is a fixed in place thing. "The Away Forge stands here out of commission.". description is "The only thing working is a series of lights forming AWAY."

check entering Away Forge:
	say "The forge is out of commission." instead;

check entering A Head Forge:
	if furniture of peace is not in lalaland:
		say "'SUBJECT HAS ARRIVED BUT HAS NOT REBELLED SUFFICIENTLY TO BE AFFECTED BY THE MACHINERY.'" instead;
	if wait paper is in lalaland:
		say "The forge already certified you. You don't need or want re-certification." instead;
	if Alec does not have wait paper:
		say "You enter, and a pen pops out of nowhere. It looks for something to write on, but it finds nothing, and it retreats. Hmm." instead;
	say "You step in, and a pen extends from the wall. It scribbles on your wait paper and folds and re-folds it. A signature, a stamp and BAM! The paper looks a lot tougher. It even sort of looks like...well, a tiger. However, in the process, the forge starts wheezing and coughing. You find it best to get out. As you do, it closes its entryway, the doors blending into the structure, with a message saying AWAY.";
	now Alec has tiger paper;
	now wait paper is in lalaland;
	now a head forge is in lalaland;
	now away forge is in sense common;
	increment the score;
	the rule succeeds;

check useoning tiger paper with head forge:
	try entering head forge instead;

check useoning tiger paper with away forge:
	try entering away forge instead;

check entering away forge:
	say "It's shut down, and there's no way in." instead;

check taking head forge:
	say "The forge is bigger than you are, and it's nailed in place. You'd be better off ENTERing it." instead;

check taking away forge:
	say "The forge is bigger than you are, and it's nailed in place. You'd be better off ENTERing it." instead;

check going inside in Sense Common:
	if away forge is in sense common:
		try entering away forge instead;
	try entering a head forge instead;

the tiger paper is a thing. description is "It's folded so it almost looks like a tiger, and it has notes about how you're good enough to at least not seem overmatched, and you probably have intangibles too, or something."

understand "tiger papers" as tiger paper.

understand "papers" as tiger paper when player has tiger paper.

book Crazy Bureau

Crazy Bureau is east of Sense Common. It is in Procrastination. "Here in Crazy Bureau, people buzz all around. You're not sure why or how, or where they're going, but they pretty much ignore you. The city proper is to the east, or you can go back west."

A Rate Coop is a container in crazy bureau. "A Rate Coop sits here, about the right size to fit a paper into.". description is "Well, it has RATE COOP printed on it, and it looks like you can put documentation in it, like a fax or printer or something."

check entering rate coop:
	say "It's too small to enter. [if tiger paper is in lalaland]It's more that you could put a paper in it[else]You put the tiger paper in it, so it probably isn't useful any more[end if].";

check taking a rate coop:
	say "It doesn't ... oh, never mind." instead;

instead of inserting into jars:
	say "The jars are closed.";

instead of inserting into jars:
	say "The solution is sealed tight.";

check inserting into:
	try useoning noun with second noun instead;

instead of putting on:
	try useoning noun with second noun instead;

check going east in Crazy Bureau:
	if purposes cross is visited:
		continue the action;
	if wait paper is off-stage:
		say "You hear blaring from the--well, a--rate coop. 'SUBJECT HAS NOT DOCUMENTED SELF TO BE SUFFICIENTLY WORLDLY WISE.'" instead;
	if tiger paper is not in lalaland:
		if Alec Smart has wait paper:
			say "[line break]The Rate Coop buzzes as you head east. Hm, maybe that wait paper would fit in. Give it a go (yes/no)?";
			if the player consents:
				try useoning wait paper with coop;
			else:
				say "OK.";
			the rule succeeds;
		if Alec Smart has tiger paper:
			say "[line break]The Rate Coop buzzes as you head east. Hm, maybe that tiger paper would fit in. Give it a go (yes/no)?";
			if the player consents:
				try useoning tiger paper with coop;
				continue the action;
			else:
				say "OK.";
			the rule succeeds;
	say "You get by just fine.";

book Purposes Cross

Purposes Cross is east of Crazy Bureau. It is in Procrastination. "You can go any of the four directions here. There's also a cross that's standing up. [one of]A gully[or]Bull Gully[stopping] leads down[bull-fear]."

every turn when Alec is in Purposes Cross (this is the hint side areas rule):
	if score < 6:
		if default-turn-count > 0 and turn count > default-turn-count + 20:
			if got-big-hint is false:
				say "You hear complaining...the Town Ghost, maybe? If you LISTEN closer here, maybe it could really help.";

got-big-hint is a truth state that varies. got-big-hint is false.

default-turn-count is a number that varies.

check going west in purposes cross (this is the push testers east rule) :
	if cross-warp is true:
		say "Sorry, but I'd have to tinker too much to let testers back west now you have an important item." instead;

to say bull-fear:
	if things-gone is 3:
		say ". You don't fear it any more";
	else if things-gone is 2:
		say ". You would love to see what's there, but you're still a bit worried";
	else if things-gone is 1:
		say ". Maybe it's not as bad as the [bad-guy-pc] says, but you don't have the guts, yet";
	else:
		say ". No way you're taking a chance there, not now. Just imagining the [bad-guy-pc] saying I Told You So? Ouch"

chapter disappointment terminal

the disappointment terminal is a thing in Purposes Cross. "[one of]A terminal sits here. It looks pretty lame[or]The Disappointment Terminal sits here, not doing anything special. [one of]And why WOULD it[or]Of course it isn't[at random][stopping]."

description of disappointment terminal is "It's disappointingly simplistic. It says PRESS DON'T PUSH A LETTER, and below are 25 of them in 5x5. It's missing a Y. Maybe why is just too deep a question."

check taking the disappointment terminal:
	say "You have enough disappointment to carry around." instead;

termpressing is an action applying to one topic.

understand the command "press" as something new.

understand "press [text]" as termpressing when player is in purposes cross.

understand "push [text]" as a mistake ("You need to press, not push, a button. That seems to be important. Somehow, the terminal can read your mind on this one. Which is kind of funny, because you can't really explain the difference between PRESS and PUSH.") when Alec is in purposes cross.

carry out termpressing:
	if Alec is not in purposes cross and Alec is not in bare cave:
		say "PUSH is the preferred verb, but actually USE works even better." instead;
	if the topic understood matches the regular expression "<^a-z>":
		say "The terminal bleeps at you for even THINKING of typing in a non-letter. How'd it know?" instead;
	unless the topic understood matches the regular expression "^.$":
		say "You try to push two letters too quickly, and the machine bleeps an ONLY ONE LETTER error." instead;
	if the topic understood matches the regular expression "y":
		say "Of course there's no button why. Such a simplistic terminal might not have the answers why. But hey, you can still ask why in your head." instead;
	if the topic understood matches the regular expression "d":
		excite-check Rust Mist;
	else if the topic understood matches the regular expression "m":
		excite-check Old Mist;
	else if the topic understood matches the regular expression "o":
		excite-check Ache Mist;
	else if the topic understood matches the regular expression "x":
		excite-check Eerie Mist;
	else:
		say "CLICK. Nothing happens.";
	the rule succeeds;

to excite-check (rm - a room):
	if rm is visited:
		say "You wonder if it'll be more fun this time, but then you remember what's sending you there. Rats.[paragraph break]";
	now mist-sc is in rm;
	move alec to rm;

chapter bull gully

Bull Gully is scenery in Purposes Cross. "[activation of gullible]Bull Gully doesn't look guarded, but that just makes it feel extra dangerous."

instead of entering bull gully, try going down instead;

to decide which number is things-gone:
	let temp be 0;
	if erotic auto is in lalaland, increment temp;
	if neutrality net is in lalaland, increment temp;
	if charming prints is in lalaland, increment temp;
	decide on temp;

check going down in Purposes Cross:
	if things-gone is 3:
		if way-out bluff is unvisited:
			say "You're ready to get a move on.";
		continue the action;
	d "[things-gone].";
	if neutrality net is not in lalaland:
		d "clear neutrality net.";
	if erotic auto is not in lalaland:
		d "clear erotic auto.";
	if charming prints is not in lalaland:
		d "clear charming prints.";
	say "Maybe the bull isn't guarding the gully. But you can't risk it." instead;

check going inside in Purposes Cross:
	say "If you could just walk in, it wouldn't be a SECRETS keep, would it?" instead;

the p-c is privately-named scenery in purposes cross. Understand "cross" as p-c. "[one of]You examine the cross without ever accusing it of being wrong, which is kind of wimpy and not very truth seeking.[paragraph break][or][stopping]It points west to Procrastination, east to Popularity, south to Power, and north to Profit."

instead of climbing p-c:
	say "It's kind of pointy and painful on top, and there's nothing up there to take." instead;

Purposes Cross is retro-anno.

book Back Quarter

Back Quarter is north of Sense Common. It is in Procrastination. "You feel terribly insignificant here, like when you got to hold a clipboard during flag football."

a wait paper is a thing. description is "It has WAIT stamped on it."

understand "papers" as wait paper when player has wait paper.

understand "wait papers" as wait paper.

The Furniture of Peace is a thing in Back Quarter. "[one of]Some furniture emblazoned with a peace sign[or]The Furniture of Peace[stopping] sits here."

check pushing furniture of peace:
	if furniture is in quarter:
		say "You push the furniture a bit, to make sure it's not too hard. Maybe you can push it in a direction so it really moves." instead;
	say "you push the furniture around a bit. Pushing it south wasn't really very exhausting, so maybe you could push it another direction." instead;

rock-furn is a truth state that varies.

check examining furniture of peace when Alec is in back quarter:
	if rock-furn is false:
		say "As you look closely, you bump into the furniture, and it rocks back and forth a bit. It might be easy to PUSH.";
		now rock-furn is true;

after pushing furniture of peace:
	now rock-furn is true;

description of Furniture of Peace is "It's decorated with peace signs and all sorts of other political symbols I won't detail. Great for making a statement without, well, doing anything."

The furniture of peace is pushable between rooms.

check taking furniture of peace:
	say "It's too heavy, but you can push it[if Alec is in sense common] some more[end if]." instead;

check pushing furniture of peace to:
	if noun is south and location of alec is back quarter:
		say "It rolls easily, and the momentum keeps it going.";
	if location of Alec is sense common:
		if second noun is west:
			say "You push the furniture into the Cadet Space. The Change Chump jumps up and down. 'Wow! You found it! Man, you oughtta be paid in PAPER, not just a coin this time.' You wonder what you can spend it on, and where, but you're disappointed to see it's, well, just paper.[paragraph break]'Here's something for you. It's sort of proof the system is rigged, so we can commiserate together.' But no. You'd actually be doing stuff.[paragraph break]You shuffle back east to Sense Common.";
			now Alec has the wait paper;
			increment the score;
			now furniture of peace is in lalaland;
			the rule succeeds;
		if second noun is inside:
			say "The furniture is too big for the forge." instead;
		if second noun is north:
			say "You use your common sense (ha! Ha!) and figure it'd be useless to push the furniture BACK." instead;
		if second noun is east:
			say "There are probably regulations against pushing something peaceful into the Crazy Bureau." instead;
		say "No sense pushing the furniture in some crazy direction. You use (wait for it) common sense and figure there's got to be one good direction it CAN go." instead;

check going west in sense common:
	if furniture of peace is in lalaland:
		say "You've gotten enough from the Change Chump, both financially and verbally." instead;
	else:
		say "[one of]As you re-enter Cadet Space, you hear the Change Chump sighs about having too many cots and it'd be nice to have some variety. Why, he'd be willing to pay you in PAPER if you found something to spruce up the place[or]You don't want to stop back to chat, but maybe if you had something for the Change Chump[stopping]." instead;

understand "piece/peace of furniture" as furniture of peace.

understand "furniture of piece" as furniture of peace.

does the player mean searching a person: it is unlikely.

check entering furniture of peace:
	say "No time for loafing around! Or a round loaf, either. As you try to sit on the furniture, it shifts, slightly." instead;

check searching Furniture of Peace:
	if effort token is off-stage:
		say "Oh! Look! You turn up a handsome coin! The Change Chump gasps. 'No, it can't be that easy, I wouldn't have overlooked it falling there. Besides, it looks neat, but it's not a [activation of token resistance]resistance token.' He goes on for a few minutes. 'It's--it's...'[paragraph break]'Too basic?' you say. You think to the times you were tricked into overthinking--but you know better than to dwell too long.";
		increment the score;
		now Alec has effort token;
		the rule succeeds;
	else:
		say "You don't need to search it again.";
	the rule succeeds;

check taking Furniture of Peace:
	say "It's REALLY opposed to violent upheavals, so, no." instead;

book Delta of Delta

Delta of Delta is south of Sense Common. It is in Procrastination. "[one of]This is a waterway that spreads out beyond where you can see. You remember doing the math to figure how far that was. You assumed a person was six feet but you were only five feet at the time, and people shouted you down for that[or]The delta remains peaceful[stopping]. A ship sensor stands silent, tall and narrow here. You can go back up to Sense Common."

Delta of Delta is below Sense Common.

the ship sensor is scenery in the Delta of Delta. "[one of]Written on the ship sensor is a long diatribe about how you really should not have expected a ship, and why did you ask, and you could see for yourself, and anyway if there was a ship they'd be going out of your way to pick you up, and you could never pay back the favor, and really, you'd better not bother to look again, and if you want to complain, well, it is just stating the facts. You almost hear it sigh, or maybe that's the wind[or]You can't bring yourself to look at the potential insults again.[stopping]."

instead of doing something with ship sensor:
	if action is procedural:
		continue the action;
	say "You can really only look at the ship sensor. There's no way to operate it."

dlt is unflip privately-named scenery in Delta of Delta. printed name of dlt is "delta water". understand "delta/water" as dlt. "It's pretty relaxing to watch, but you don't feel like it really changes or does anything."

a thing can be firstpuzzly.

a thing can be usenorm, tripuzzly, wordpuzzly or propagandy. a thing is usually usenorm.

A Solution of Solution is firstpuzzly thing. description of solution is "[one of]Looking closer, you see it[or]It[stopping] says Solution of Solution (TM). Empty, of course.".

The Jars of Jars are a plural-named firstpuzzly thing. description of jars is "[one of]Looking closer, you see they[or]They[stopping] say Jars of Jars (TM). Empty, of course.".

understand "jar/jars of jar/jars" and "jar" as jars of jars.

A Bottle of Bottle is an opaque firstpuzzly container.

check taking inventory when number of things held by Alec Smart is 0:
	say "[one of]You are carrying nothing. Well, nothing that'd help in an adventure. You didn't, like, lose your keys or anything[or]You are carrying nothing special[stopping]." instead;

after printing the name of the bottle while taking inventory (this is the bottle contents rule) :
	if gas is in bottle:
		say " (containing guzzler gas)";
	if slime is in bottle:
		say " (containing bawl slime)";
	omit contents in listing.

check opening an firstpuzzly thing:
	say "You will automatically open or close the [noun] whenever you need to." instead;

check closing an firstpuzzly thing:
	say "You will automatically open or close the [noun] whenever you need to." instead;

instead of inserting something into bottle:
	say "The bottle is really only good for holding liquid."

understand "vial/vile" and "vile vial" as solution of solution.

description of bottle of bottle is "Scratched on it is Bottle of Bottle[contain-bottle]."

to say contain-bottle:
	if slime is in bottle:
		say ". It contains the bawl slime you got from the Erotic Auto";
	else if gas is in bottle:
		say ". It contains the guzzler gas that dripped from the Neutrality Net";

to delta-look:
	if solution is examined and bottle is examined:
		say "Yup, that's empty, too. But you had to look.";
	else:
		say "Unsurprisingly, with the (TM), it's, err, empty.";

instead of drinking an firstpuzzly thing:
	say "You overturn the [noun], but nothing comes out. You put it back down.";

instead of eating an firstpuzzly thing:
	say "Your teeth are pretty good, and you don't want to ruin them by trying to bite a hard container.";

to decide which room is vis-loc:
	if comedy-club is visited, decide on comedy-club;
	if snipe gutter is visited, decide on snipe gutter;
	decide on Lent-You-Corp;

check taking a firstpuzzly thing:
	if noun is a random thing held by alec smart:
		say "You already have [if noun is plural-named]those[else]that[end if]." instead;
	if comedy-club is visited or Lent-You-Corp is visited or snipe gutter is visited:
		if score > 4:
			say "You feel greedy trying to snap up another item from here. The first one you took helped you get somewhere, and maybe that's enough for now." instead;
		say "The [noun] rolls away from you, and the [list of firstpuzzly things held by alec smart] feels a bit warmer. You think back to how the [list of firstpuzzly things held by alec smart] helped you into the [vis-loc], and maybe it's time you figured what to do there." instead;
	if number of firstpuzzly things held by Alec Smart > 0:
		say "You sense the [list of firstpuzzly things carried by Alec Smart] rattling. You probably can't carry both items at once. Drop what you have?";
		if the player consents:
			say "You place the [random firstpuzzly thing held by Alec Smart] carefully";
			say " on the ground and take the [noun] instead.";
			now all firstpuzzly things carried by Alec Smart are in delta of delta;
		else:
			say "OK.";
			the rule succeeds;

after taking inventory:
	if Alec carries bottle of bottle:
		say "You feel more confident holding the bottle.";
	else if Alec carries the Solution:
		say "You feel wiser and cleverer holding the solution.";
	else if Alec carries the jars:
		say "The jars leave you feeling, strangely, less jarred by anything that might happen."

after taking bottle of bottle:
	say "[one of]The bottle is empty, but when you take it, you feel more brash and confident[or]You feel a confidence boost again[stopping].";

after taking solution of solution:
	say "[one of]It's sort of a vile vial as well (to look at--it's a bit ugly but not evil), but you feel wiser just holding it[or]You feel wisdom returning again[stopping]."

after taking jars of jars:
	say "[one of]The jars knock slightly against each other, back and forth, like a Newton's Cradle. You remember the day you got zinged for actually knowing what one was, but it doesn't make you as mad as it might've before. It's relaxing to know you can survive small conflicts[or]You feel more resilient again[stopping].";

chapter void take all

this is the hoarding rule:
	if Alec is in delta of delta:
		if word number 1 in the player's command is "get" or word number 1 in the player's command is "take":
			if the number of entries in the multiple object list is greater than 1:
				let Q be entry 1 of the multiple object list;
				say "You try to take the [Q], but [if Q is plural-named]they roll[else]it rolls[end if] away. Maybe you should pick things up one at a time.";
				stop the action.

The hoarding rule is listed before the generate action rule in the turn sequence rules.

volume Profit Region

There is a region called Profit.

book Profit Turn

Profit Turn is north of Purposes Cross. It is in Profit. "Passages in all four directions. You can go up to [if production peak is visited]Production Peak[else]a peak[end if], south to Purposes Cross, down to somewhere secretive, or east to some sort of comedy club."

the erotic auto is a tripuzzly thing in profit turn. description is "It's got all kinds of features that you don't have any clue about except that they're apparently powerful and impressive. It looks very expensive, though you never knew or understood why it had to be, or why people would buy something like this.". "The Erotic Auto sits here, looking advanced and desirable and worth every dollar it is overpriced."

understand "car" as auto

check entering erotic auto:
	say "You have no key and no idea how to drive something like this. Anyway, it's a bit--well, really--excessive." instead;

check pushing erotic auto:
	say "Well, you'd have to break it down first." instead;

check taking erotic auto:
	say "It's far too heavy." instead;

the bawl slime is a thing. description is "It's kind of icky, and you don't want to touch it. You feel like crying just looking at it. It's sure to be a downer to anything except, well, an inanimate bottle.".

the upright bolt is a thing. description is "It's weirdly shaped, for a bolt that came from a car. It's like a stereotypical lightning bolt, all zigzagged. You're not sure how it fit in the Erotic Auto, or maybe it was just there to destroy the Erotic Auto at the slightest jolt, because that was the right thing to do. But it's tough to keep it from pointing straight up."

check going east in profit turn:
	consider the culture-available rule;
	if the rule failed:
		the rule succeeds;

this is the culture-available rule:
	if poker strip is not off-stage:
		say "You got the poker strip from there. You don't need anything more.";
		the rule fails;
	if Alec does not have bottle of bottle:
		say "[one of]You take a step in, but a barrage of insults brushes you back. You don't quite have the guts to face them. Well, maybe you don't need to[or]The fresh insults coming from the comedy club leave you a bit too panicky. You'd need some sort of boost[stopping].";
		the rule fails;
	if comedy-club is unvisited:
		say "The stream of unfunny jokes ahead makes you cringe, but you grasp the bottle and realize you've deal with worse. You'll put up with this.";
	the rule succeeds;

to decide whether the action is undrastic:
	if examining, decide yes;
	if explaining, decide yes;
	decide no;

book Production Peak

Production Peak is north of Profit Turn. It is in Profit. "While there's a lot of bustle going on, the main attraction is a Homonym Ad that blinks and changes constantly. You can go back down south to Profit Turn."

Production Peak is above Profit Turn.

section homonym ads

the Homonym Ad is scenery in Production Peak. "[hom-ad]."

check taking homonym ad:
	say "That's some important corporation's property! And it's too big. And it's bolted to the ground." instead;

to say hom-ad:
	increment current-ad;
	if current-ad > number of rows in table of homonym ads:
		now current-ad is 0;
		say "The ad blinks a bit. It's probably resetting. You feel as though you probably weren't excited by all that advertisement as you should have been.";
		continue the action;
	choose row current-ad in table of homonym ads;
	say "The homonym ad [homad entry] [if erotic auto is in profit turn][one of]You feel very depressed after reading the ad, as if you aren't good enough to appreciate it, or you maybe think you deserve it more than you should, or you don't deserve it enough, or the people who commissioned it know more about creativity than you and you just don't know it yet[or]Its glibness leaves you feeling very unworldly for not being suckered by it[stopping][else][one of]It seems a bit silly, now. If whatever it's selling is as useful/useless as the erotic auto, why bother[or]More silliness[stopping][end if]";

current-ad is a number that varies.

table of homonym ads
homad
"endorses a thrown throne."
"endorses tense tents."
"endorses a TV show, Rheumy Roomie."
"endorses Beaut Butte."
"endorses Patience Patients."
"endorses Principal Principle."
"endorses Chance chants."
"promotes Loners['] Loaners."
"flashes a Cygnet signet."
"blasts Sore? SOAR!!!"
"blasts Soot? Suit!!!"
"blasts Sordid? Sorted!!!"

volume Popularity Region

There is a region called Popularity.

book Way of Right

There is a room called Way of Right. It is east of purposes cross. It is in Popularity. "You can go back west to Purposes Cross, east to [if artistcon is visited]ArtistCon[else]some sort of convention[end if], north to [if comedy-club is visited][comedy-club][else]a comedy club[end if], or south to [if snipe gutter is visited]Snipe Gutter[else]some sleazy alley[end if]. [eval-ways]."

to say eval-ways:
	if Alec is in way of right:
		if buckle is not off-stage or poker strip is not off-stage:
			say "You don't know if you want to get sidetracked any more, though";
			continue the action;
		if bottle is in delta and jars are in delta:
			say "But the club and the alley seem a bit too rough";
		else if bottle is in delta:
			say "The club seems a bit too risque for you";
		else if jars are in delta:
			say "That alley seems kind of rough, though";
	if Alec is in jungle of law:
		if solution is in lalaland or buckle is not off-stage:
			say "You don't know if you want to get sidetracked any more, though";
			continue the action;
		if solution is in delta and jars are in delta:
			say "The bar seems a bit too rough right now";
		else if solution is in delta:
			say "You don't feel up to hanging out by a bar right now";
		else if jars are in delta:
			say "That alley seems a bit too rough right now";
	if Alec is in profit turn:
		if poker strip is not off-stage or solution is in lalaland:
			say "You don't know if you want to get sidetracked any more, though";
			continue the action;
		if bottle is in delta and solution is in delta:
			say "But the bar and the club seem a bit too rough";
		else if bottle is in delta:
			say "But the club seems a bit too rough";
		else if solution is in delta:
			say "But the alley seems a bit too rough";

the charming prints are a tripuzzly plural-named fixed in place thing in Way of Right.

after doing something with charming prints:
	set the pronoun it to charming prints;
	continue the action;

check taking charming prints:
	say "You might take their advice, but you can't take them. They're sort of fixed into the scenery, here." instead;

description of charming prints is "[one of]The prints contain all manner of ways to, well, just feel right to other people[or]You read some more alleged self-improvement[stopping]. Beyond the usual positive-thinking and make-others-feel-swell argle-bargle, there's specific advice.[paragraph break][print-advice]"

charm-row is a number that varies.

understand "print" and "charming print" as charming prints.

understand "lesson/lessons" as charming prints when alec is in Way of Right.

to say print-advice:
	if charm-row is 0:
		say "There's some long arglebargle about how the charming prints aren't about being morally right, but about being right for society or the people around you, and that is morally right, in a way. Your head spins a bit. You can examine it [number of rows in table of charms in words] times to see its complete wisdom.[run paragraph on][line break]";
		increment charm-row;
		continue the action;
	choose row charm-row in table of charms;
	say "[charmtext entry]";
	increment charm-row;
	if charm-row > number of rows in table of charms:
		say "[paragraph break]You've reached the end. Whew.";
		now charm-row is 0;

table of charms
charmtext
"Keeping it real is very, very important."
"You need to be very serious about not being too serious."
"Be in touch with your inner child, but be sure to tell people to grow up."
"A hearty laugh will make you more likable, and if you don't think you can manufacture one, you don't deserve to."
"Remember to make even your negative thinking exciting."
"People who aren't full of life are just projecting their own boredom onto other people. Don't be a loser like that!"
"Jollying along people who whine others need to be nicer, then noticing they aren't very grateful."
"Knowing pop culture more than clueless bums and yet--and yet--realizing you deserve better."
"Reciprocal backslapping with good friends that you both deserve more out of life."


the proof bullet is a thing. description is "If you look closely, you can make out all sorts of logical symbols, like the triangle of dots, congruence signs, arrows, and so forth. You feel a surge as you roll it around. It may be effective even without a gun."

the worm hook is a thing. description is "The worm hook squirms in your hand as you look at it. It's pretty thin, and it's also pliable enough to poke around tricky areas."

check going north in way of right:
	consider the culture-available rule;
	if the rule failed:
		the rule succeeds;

check going south in way of right:
	consider the snipe-there rule;
	if the rule failed:
		the rule succeeds;

book ArtistCon

ArtistCon is east of Way of Right. It is in Popularity. "People brag about their accomplishments here. You can go back out west, or you can read the notes bank here to help struggling artists."

the notes bank is scenery in ArtistCon. description is "Creativity advice: [no-ba][line break]"

notes-row is a number that varies. notes-row is 0.

to say no-ba:
	increment notes-row;
	choose row notes-row in table of notestuff;
	say "[notetext entry][line break]";
	if notes-row is number of rows in table of notestuff:
		now notes-row is 0;
		say "[line break]Whew! That's all.[run paragraph on]";
		continue the action;
	say "[line break][one of]Wow, that seemed--true and not true at the same time. It seemed true, basically, but... maybe you need to look at it artistically to understand it fully, but if you could understand it, you wouldn't need it.[run paragraph on][or]Well, art sort of is that way, full of apparent self-contradictions. And yet...[run paragraph on][stopping]"

table of notestuff
notetext
"HAVE STRONG OPINIONS. Even if your strong opinions are that you're too good to have opinions about things."
"Capture the zeitgeist of the moment. If you need that explained, you don't deserve to know."
"Babble on about how art transcends societal divisions, but all the same, have a genre you really, really hate."

check taking notes bank:
	say "Wel, you can just take notes by examining it. Ho ho ho." instead;

volume Power Region

There is a region called Power.

book jungle of law

Jungle of Law is south of Purposes cross. It is in Power. "Arguments of all sorts bounce about here, big and small, loud and soft. There's a small safe-looking area to the west, but you can also go down, or back north to Purposes Cross[if net is in lalaland]. Unfortunately, the Neutrality Net wasn't guarding some cool secret passage south[end if]."

the neutrality net is a tripuzzly fixed in place thing in Jungle of Law. "[one of]A big net[or]The Neutrality Net[stopping] encompasses much of the south wall."

the right knot is part of the neutrality net. description is "Every single right not looks okay and sturdy, and altogether they're impressive, and yet..."

understand "knots" and "right knots" as right knot.

instead of doing something with the right knot:
	say "You need to do something to the whole Neutrality Net."

instead of entering net:
	say "You'd get tangled up quickly in its logic. And its knots." instead;

check taking neutrality net:
	say "The neutrality net, much like people who boast they're really, really neutral, is utterly immovable." instead;

check climbing neutrality net:
	say "It's too all-encompassing for that." instead;

description of neutrality net is "[one of]You're hypnotically drawn to it, and it seems intricately tied with big and small knots that might take forever to untie on your own. After a good long gaze you feel 'reassured' that your opinion on big things can't matter, and your opinion on small things can't matter, but for entirely different reasons, and you just haven't been objective enough, even or especially around people with more passionate arguments than you.[paragraph break][or]Gazing into the neutrality net gives you more objectivity. For certain definitions of objectivity. [stopping][net-advice]"

net-row is a number that varies. net-row is usually 0.

to say net-advice:
	increment net-row;
	choose row net-row in table of netness;
	say "It seems to say to you: [netstuff entry]";
	if net-row is number of rows in table of netness:
		now net-row is 0;
		say "[paragraph break]Well, that's the end. It was enlightening. You think. After pausing, you wonder if it would've been more enlightening if you'd been properly neutral.[no line break]";

table of netness
netstuff
"People more aggressive than you have feelings too. Even more feelings than you do! Of course they do."
"If you have no passion, respect those who do. If you have passion, realize everyone else probably thinks you're overdoing it."
"Be very impressed by someone who is factually wrong if they are committed to their cause."
"If someone smarter than you calls you stupid, they're right. If someone dumber than you calls you stupid, hey, maybe they just need to feel smart."
"Remember: people who wonder why you'd bother to remember THAT, and people who wonder why or how you could forget THIS, both have a point."
"There's stuff that's subjective, and there's stuff that isn't."
"Feel silly thinking anyone can give you the answer, or that you can find it on your own."
"People who are more exciting about being neutral deserve to be."
"Always be neutral, except, y'know, about the FACTS."
"If you think you are being pushed around, remember, even if you have low self esteem, you are PUSHING THE FACTS AROUND IN YOUR FAVOR, SUBCONSCIOUSLY OR OTHERWISE."

the light engine is a thing. description is "You don't know much about engines, but this one looks pretty sophisticated and efficient."

guzzler gas is a thing. description is "The guzzler gas is sloshing against the bottle, which must be a pretty strong container."

instead of inserting gas into erotic auto:
	ignore the can't insert what's not held rule;
	try useoning gas with erotic auto instead;

before taking:
	if bottle of bottle contains the noun:
		say "That'd be dangerous. Keep it in the bottle til you can use it." instead;

book protection cavity

Protection Cavity is west of Jungle of Law. It is in Power. "You feel safe here except from someone maybe asking for a gratitude fee for making you feel safe from, well, I don't know, rackets? It'd hurt to get hit with a flying racket![paragraph break]As a bonus, there's a Picker Rag explaining everything you're protected from, or can be protected from, or need to be worried about if you're not. You can go back out east."

the picker rag is scenery in protection cavity.

check taking the picker rag:
	say "It's not an actual rag, and given it's in the Protection Cavity, it probably has some sort of security. You can just read through it as need be." instead;

rag-expound is a truth state that varies.

check examining picker rag:
	if rag-expound is true:
		say "[if neutrality net is in jungle of law]Reading the picker rag you understand how the leaders of Square Town, soon to be Slicker City, are indeed making things freer for expression and intrigue and not being pushed around by people too lazy to gain power. Of course there's a note this may upset any such types reading this, but they need to deal[else]Reading the picker rag, it seems slightly rubbish. The arguments make sense if you're not paying attention, but the bit about people being lazy--well, yeah, it is hard work to refute glib arguments like that[end if].";
		now rag-expound is false;
		say "[line break]";

description of picker rag is "[rand-pick]".

pick-index is a number that varies.

to say rand-pick:
	if pick-index is number of rows in table of picks:
		say "The last page, of course, is labeled 'final picking-knows' and about nose picking being much worse than we think.[run paragraph on][line break]";
		now pick-index is 0;
		continue the action;
	increment pick-index;
	choose row pick-index in table of picks;
	say "One page says: look out for people who [picky entry]";

table of picks
picky
"are too nice are suspicious, but people who are too exciting can't be."
"pause a lot during conversation SUBCONSCIOUSLY HAVE A DESIRE TO WASTE OTHERS['] VERY LIMITED TIME ON EARTH."
"don't seem any good at being subversive, but they sure aren't useful at following orders."
"want lots of time to themselves despite not really being interesting enough to, well, be with for long."
"seem easy to push around, except when it might be good for society."

volume Partnership Region

Partnership is a region.

book comedy-club

comedy-club is east of profit turn. it is north of Way of Right. it is in Partnership. "This comedy club advertises big laughs, but not necessarily quality ones. A wit staircase leads up. Exits lead west and south."

the wit staircase is scenery in comedy-club. description is "Just looking at it, you fantasize about snappy comebacks to others['] insults. Or at least clever deflections."

instead of climbing wit staircase:
	try going up instead.
	
check going up in comedy-club:
	if kay riss is in comedy-club:
		say "Not with Kay Riss around." instead;
	say "As you ascend the Wit Staircase, you hit yourself on the head. That's a pretty cleverly painted ceiling! Well, you still got that Poker Strip out of the deal." instead;

comedy-club is privately-named. printed name of comedy-club is "[if swears is true]Shock Culture[else]Cheese Cottage[end if]"

understand "shock/culture" and "shock culture" as comedy-club when swears is true.
understand "cheese/cottage" and "cheese cottage" as comedy-club when swears is false.

the poker strip is a thing. description is "It's, well, probably useful for poking at things until you make a small hole."

Instead of taking poker strip:
	say "'You have to earn it by defeating me!' says Kay Riss." instead;

Kay Riss is a person in comedy-club. "[one of]The current flavor-of-the-month comic[or]Kay Riss[stopping] stands here, soaking up unseen applause and laughter.". description is "Kay Riss is wearing a shiny pantsuit and a shiny tie, the sort only a comedian can wear. Outfits like that make [if swears is true]swears and innuendo[else]ill-informed 'observational humor'[end if] extra classy!"

understand "comic" as Kay Riss.

every turn when Alec is in comedy-club and kay riss is in comedy-club:
	say "Kay Riss cracks a joke about ";
	if swears is false:
		say "[one of]Christmas fruitcake[or]scientifically disproven 'common sense' solutions to big problems[or]a math concept that's not THAT painful if you think about it[or]fifth-rate trauma from [his-her] own terribly repressed nerdhood[or]a celebrity and TV show already on the downslide[or]a scientific theory [he-she] states simply and wrongly[or]an on-its-way-out trend you never understood anyway[or]people who are too fat and people in a bit too good shape[or]getting stuck in traffic[or]celebrities that aren't beautiful enough to be celebrities, and how fame and looks don't really matter[or]people who are too dumb and people who are too smart[or]foreign culture [he-she] doesn't understand in the first place[or]why they don't make airplanes out of the black box material[in random order].";
	else:
		say "[one of]Bill Clinton and that White House intern, ha ha ha ha ha[or]how Mexican food gives you the runs[or]someone too ugly to be famous, followed by self-depreciation of their own looks[or]a celebrity's latest sex tape[or]that popular new song that rhymes two swear words that don't actually rhyme[or]former lovers['] bedtime habits[or]an obvious double entendre you'd get beaten up for[or]body noises and blemishes[in random order].";
	say "[line break][one of]You hear a laugh. It sounds fake, but maybe if you could get rid of it, it would demoralize Kay Riss.[or]The canned laugh continues. The joke wasn't THAT funny. Where is it coming from?[or]You try to figure where the laugh is coming from. Analyzing...[or]You trace the laugh some more.[or]Where is the laugh trail now, you think.[or]How to get that laugh off the rails?[cycling]";

to say his-her:
	if kay riss is female:
		say "her";
	else:
		say "his";

to say he-she:
	if kay riss is female:
		say "her";
	else:
		say "she";

to say him-her:
	if kay riss is female:
		say "her";
	else:
		say "him";

when play begins:
	if a random chance of 1 in 2 succeeds:
		now kay riss is female;

chapter tracklaughing

understand "strip comic" as a mistake ("This isn't that sort of game.") when Alec is in comedy-club and kay is in comedy-club.

understand "club comedy" as a mistake ("You don't have a useful weapon.") when Alec is in comedy-club and kay is in comedy-club.

tracklaughing is an action applying to nothing.

understand the command "track" as something new.

understand "track laugh/laughing/laughter" as tracklaughing when Alec is in comedy-club.

understand "laugh" and "laugh [text]" as a mistake ("You couldn't bring yourself to laugh, or fake-laugh. But what if you could do something to the laugh?") when Alec is in comedy-club and kay is in comedy-club.

understand "track [text]" as a mistake ("You're close. You want to track the laugh.") when Alec is in comedy-club and kay is in comedy-club.

carry out tracklaughing:
	say "You challenge Kay to give you their funniest joke. You're kind of cranky, though, and you see why you should laugh, but you don't care. Kay forces a laugh and claims it's because you're clueless. Then tries another, then another. Eventually you get brave enough to explain why you don't find it funny, but lame people might. To escape [his-her] failure, Kay flees up a wit staircase you didn't notice before, but not before flinging a poker strip at you. You pick it up.";
	now Alec has poker strip;
	now kay riss is in lalaland;
	increment the score;
	the rule succeeds;

book Lent-You-Corp

Lent-You-Corp is a room in Partnership. It is below Jungle of Law. "This is a suitably dark place for a shadowy corporation to do its thing. A crasher gate blocks you going exploring in any detail, but there are two ways back up: north [if profit turn is unvisited]where you haven't been[else]to Profit Turn[end if] and south [if jungle of law is unvisited]where you haven't been[else]to the Jungle of Law[end if]."

the crasher gate is scenery in lent-you-corp. "It's sturdy enough to prevent people from going where they aren't supposed to be."

check opening crasher gate:
	say "You might set off some sort of alarm." instead;

check entering crasher gate:
	say "You might set off some sort of alarm." instead;

the Player Roll is a fixed in place wordpuzzly thing in Lent-You-Corp. "A big computer labeled the Player Roll takes up the middle of Lent-You-Corp."

understand "play roll" as a mistake ("You're not sure how to play it. How would you create an ideal simulation, a framework, to change the Player Roll?") when player is in lent-you-corp and player roll is in lent-you-corp.

understand "computer" as player roll when player is in lent-you-corp and player roll is in lent-you-corp.

description of Player Roll is "Seeing the calculations it performs and the people it looks to burden with ridiculous financial obligations, it makes you mad. So mad you'd be willing to break a bone trying to destroy the Compound. Apparently it might interest some people with all the clever loopholes or the ability to calculate penalties and such that build on each other, but it just doesn't seem fair to you."

check taking Player Roll:
	say "It'd become exponentially harder to carry." instead;

every turn when Alec is in Lent-You-Corp and Player Roll is in Lent-You-Corp:
	say "[one of]The Player Roll sticks out. You need to reform it somehow.[or]You're jealous that the people building the Player Roll have enough money to date very beautiful women whose mere image can get other people to spend tons of money.[or]You feel regret you're a perfect citizen.[or]You feel regret you spent time building trains and airplanes and so forth instead of financial empires, despite yourself.[or]You are depressed something like the Player Roll could be fashionable.[cycling]" instead;

the context device is a thing. description is "It's just a squarish box with the usual blinking lights. But just staring at it and thinking of old conversations, you remember ones you took too literally--and ones shouldn't have taken literally at all. So obvious now. Eh, lessons for later."

check switching on roll:
	say "It can't be that easy to disable it. Some other action, maybe." instead;

check switching off roll:
	say "It can't be that easy to disable it. Some other action, maybe." instead;

check going in Lent-You-Corp:
	if noun is south or noun is southeast:
		move Alec to jungle of law;
		the rule succeeds;
	if noun is north or noun is northeast:
		move Alec to profit turn;
		the rule succeeds;
	if noun is up:
		if back-to-law is true:
			move alec to jungle of law;
		else:
			move alec to profit turn;
		the rule succeeds;

Lent-You-Corp is below Profit Turn.

understand "tied roll" as a mistake ("The Player Roll is, alas, not teleported to Alabama.") when player is in Lent-You-Corp and player roll is in lent-you-corp.

check going west in profit turn:
	try going down instead;

Profit Turn is north of Lent-You-Corp.

back-to-law is a truth state that varies.

this is the enter-corp rule:
	if solution is in lalaland:
		say "After the mess you made in Lent-You-Corp, you don't want to go back.";
		the rule fails;
	if player does not have solution:
		say "The sight of a big intimidating computer leaves you feeling you don't have or know any way around it.";
		the rule fails;
	if lent-you-corp is unvisited:
		say "A tall computer's humming and wheezing, along with an intimidating gate, leave you feeling a bit initimidated and hopeless. But then you grasp the solution of solution a bit harder. Maybe there's a way to deal with things, and maybe it's not too complex.";
	the rule succeeds;

check going down in Jungle of Law:
	consider the enter-corp rule;
	if the rule failed:
		the rule succeeds;
	now back-to-law is true;

check going down in Profit Turn:
	consider the enter-corp rule;
	if the rule failed:
		the rule succeeds;
	now back-to-law is false;

chapter rollmodeling

rollmodeling is an action applying to nothing.

understand the command "model roll" as something new.

understand "model roll" as rollmodeling when Alec is in Lent-You-Corp.

carry out rollmodeling:
	if Alec Smart has context device:
		say "There's nobody to whine to any more." instead;
	say "You remember your old days of hacking into friends['] programs and changing them around. Today must be your lucky day, because some of your old techniques work. Or maybe it's just because you spilled the solution of solution on the Roll as you got to hacking. You find a back door into the Player Roll's algorithm itself. Slowly, the names start changing. But then something odd happens: the roll itself pops up on the screen! It tries to loan money to itself at exorbitant rates, and it gets caught between huge profits and terrible loans. Slowly, though, the service fees from repeat transactions grow. The Player Roll begins to smoke (not a cigarette of course. That'd be much worse than ripping off people much poorer than oneself!) Panels begin falling all over the place, and circuit boards begin popping and fizzing. You run around in circles until the noise stops, before realizing you probably should have just run out for your safety, especially when the Crasher Gate comes falling down on the Player Roll.[paragraph break]BAM! A lot of the Player Roll is completely fried. But one small chunk of metal remains blinking. It's labeled CONTEXT DEVICE. You pick it up, then run out before you get caught.";
	now Alec has the context device;
	now solution of solution is in lalaland;
	increment the score;
	if back-to-law is true:
		now Alec is in jungle of law;
	else:
		now Alec is in profit turn;
	the rule succeeds;

check going east in jungle:
	consider the snipe-there rule;
	if the rule failed:
		the rule succeeds;

this is the snipe-there rule:
	if buckle is not off-stage:
		say "You already dealt with the Snipe Gutter and don't want to go back.";
		the rule fails;
	if Alec does not have jars:
		say "The invective coming from the [if Alec is in jungle]east[else]south[end if] is a bit too much for you. You feel rattled, with nothing to soak it up.";
		the rule fails;
	if snipe gutter is unvisited:
		say "The invective grows louder, but the jars seem to rattle and bounce it back and deflect it enough for you to get close.";
	the rule succeeds;

book Snipe Gutter

Snipe Gutter is east of jungle of law. It is in Partnership. It is south of way of right. "You can go west or north here."

Terry Common is a person in Snipe Gutter. description is "He's dressed in the latest regular-guy fashion, and he seems to wear it better than most. He's in decent physical shape, good enough to make fun of people who aren't. He's--well, it's a half smile, the sort that shows he's got a bit of snark in him. A bit? No. More than a bit."

understand "bill terry" as a mistake ("That'd be a fun idea.  An invoice for a therapy bill. But you don't have the guts to pull that off.") when Alec is in Snipe Gutter and Terry Common is in Snipe Gutter.

understand "comment" and "comment [text]" as a mistake ("You need to comment something, the other way around.") when Alec is in Snipe Gutter and Terry Common is in Snipe Gutter.

understand "[text] comment" as a mistake ("You need to comment something, the other way around.") when Alec is in Snipe Gutter and Terry Common is in Snipe Gutter.

the under buckle is a thing. description is "It's rolled up now, but it looks like it could roll out and snap and crunch something not built strongly enough."

every turn when Alec is in snipe gutter and terry common is in snipe gutter:
	say "[one of]'Do you have a comment? Guess not.' Terry resumes talking about whatever.[or]Terry's talking rapidly, and you feel like you can't get in one comment. Well, maybe a very short one.[or]Terry's ridiculous take on a current hot social situation leaves you shaking your head. He interprets your silence as agreement.[or]You wonder if a quick COMMENT could stall Terry's bluster. Even one that doesn't seem like a comment.[cycling]"

chapter commentnoing

commentnoing is an action applying to nothing.

understand the command "comment no" as something new.
understand the command "no comment" as something new.

understand "no comment" as commentnoing when Alec is in snipe gutter.
understand "comment no" as commentnoing when Alec is in snipe gutter.

carry out commentnoing:
	if Alec is in snipe gutter:
		if terry common is in lalaland:
			say "You already did." instead;
		say "You are amazed at the vehemence with which you just say, no, no, no, that doesn't make sense. Terry bemoans your repetitiveness with some of his own--but it's different for him, see. Suddenly you see a bit more persistence would've worked in other arguments and will in the future. Terry pulls out something'Here you go, you win the under buckle, I guess, for what it's worth.'";
		now Alec has under buckle;
		now terry common is in lalaland;
		increment the score;
	the rule succeeds;



volume bookery

volume first-timing

after printing the locale description when location of Alec is unvisited (this is the first time do stuff rule) : [xxap]
	repeat through table of unvisiteds:
		if location of Alec is a loc-to-write entry:
			say "[init-unvis entry][line break]";
			if there is a rule-to-try entry:
				consider the rule-to-try entry;
			continue the action;
	continue the action;

table of unvisiteds [xxu]
loc-to-write	rule-to-try (rule)	init-unvis
That Thought Park	--	"You remember the whole argument. His voice. Sort of mocking, sort of factual. 'Look at me! I'm Alec Smart! Watch me [activation of rigidly]idly rig things in my favor, adding silly little details to my new little world, to seem like the underdog...when really I am just lucky everything was arranged just SO, for me to get through the Problems Compound. Those puzzles sure were fun! Until they applied to, y'know, real life.'[paragraph break]You haven't thought about him for a while. Sometimes, people reminded you of him, and that helped you fend them off a bit. But not long enough. Then you felt almost...thankful to HIM. How to shake that?[paragraph break][i][bracket]NOTE: you can type V or VERBS to see the verbs used in the game, and you could also type ABOUT to see information about the game itself.[close bracket][r]"
Bees Wood	trees-wood rule	"You still hear the [bad-guy-pc] at times, mocking you with 'I [activation of augment]meant...augh...' when you are right, or you're pretty sure you're right, and someone's misunderstanding you deliberately and they know you can't and won't call them on it. There are still silly fears out there. You'd like to--fix that, somehow."
A Feel Copse	trees-copse rule	"The [bad-guy-pc]'s voice echoes in your brain. 'Look at me! I am [activation of forbidden]bidden for! By my own private Narnia! If I find it again, I'm really off in space, but if I don't, why, I just must not be imaginative enough.'"
Cadet Space	--	"'Say hi to the Change Chump!' says the [bad-guy-pc]. 'He's opposed to Square Town becoming Slicker City, too. Spend a bit of time around him, and you might, well, want to cooperate with us.'"
Sense Common	--	"'Ah! You again. You got out. Embarrassingly easy, wasn't it? But that's kind of the point.' The [bad-guy-pc], again. 'Just thought I'd [activation of check in]check in. Maybe you can help the Change Chump--even if you don't want to go back to see him. A Head Forge here will decide if you've done enough. Don't worry, it's not that bad--but you better not feel too accomplished once you figure it out.'"
Crazy Bureau	--	"The [bad-guy-pc]'s voice crackles over a hidden loudspeaker. 'Proper notification is needed to progress to Square Town AKA Slicker City.  But, well, it's just like getting a permission slip signed for a field trip. You never forgot that, did you? Say! You look like you want to [activation of backstab]stab back! Really, after all I've done for you. And me being busy. Maybe the Town Ghost will help you if you get in the city. Just, watch out for [activation of gullible]Bull Gully when you get there! It might be guarded by a vicious bull you can't see. Or it might not.'"
Delta of Delta	delta-drop rule	"You look around for the [bad-guy-pc], but you don't see him anywhere. It's almost too peaceful here. Too peaceful. You remember an adult giving you a bunch of books to read and you went for [i]Siddhartha[r] because it was shortest. Then that bit about the water staying the same and changing at the same time. You felt bad feeling cynical about it, then it felt cheesy once it made sense."
Purposes Cross	got-first-puz rule	"You hear obligatory whoo-ing and whoah-ing. You look around and see nothing. 'Sorry about that. I feel sort of obliged, as the Town Ghost. You won't get to see most of Slicker City here, but the Three Symbols must be dispelled. First, though, you must infiltrate one of the buildings nearby. You can also poke around the Disappointment Terminal here, but...the results will likely be...disappointing.'"
comedy-club	--	"'Ah! Another fan! Welcome to the Kay Riss show! I'm the headliner of this comedy club, and I'm provably funny!'"
Snipe Gutter	--	"'Oh hey, look, it's [activation of zeho]our zero. Terry Common. Only he's not really a zero, he's just an average guy like you or me. Well, you, and he's a bit more observant.'"
Profit Turn	--	"'The Erotic Auto!' whispers the Town Ghost. 'Made to impress people who know lots about cars, and people who don't! Just being around it makes a person feel guilty. And yet...it has not passed safety inspections yet. Perhaps you could find a way it is still wanting.'"
Production Peak	--	"'Hear that?' says the Town Ghost. 'That is a TRAP CLAP[activation of claptrap], a single clap to guilt people into working harder, or multiple to flatter them into doing more. The [activation of business instinct]instinct business is strong here. The homonym ad leaves people feeling guilty of what they don't have. So much action and worry is produced, here.'"
Jungle of Law	--	"'The Jungle of Law! So tangled, you will be hard pressed to explore beyond the entrance. And the Neutrality Net. It has tied so many people into doing nothing. Convincing people they're not original, or unique, or they don't have life skills. Wearing them down with details, or overgeneralizations. So much that was [activation of nuance]once new.'"
Protection Cavity	--	"'Here in the protection cavity people are protected from even thinking why they need to be protected.'"
Lent-You-Corp	--	"'You have no chance of seeing all of Lent-You-Corp! But perhaps you can strike a blow against the Player Roll? Its [']financial services['] are well within the laws, and if they aren't, the laws have a way of changing to accomodate new business ideas. In time most all will be served'"
Back Quarter	--	"'Obscure little place, isn't it? Makes you feel like a bit of physical exertion, maybe?'"
Way of Right	--	"'The way of right is about feeling right and showing you're right. And apparently being right, if the charming prints are to be believed and trusted. They have a way of seeming just right, but they can't be...'"
ArtistCon	--	"'ArtistCon. It's not quite prepared yet, but one day, there'll be artists here, as well as people who support the arts. The most exciting will win out. Of course, there will still be art for the underdog. As long as the underdog proves they're worth it. The notes bank is all there is here, so far.'"
Way-Out Bluff	grate-place rule	"You go to touch the rock, and it shimmers. Holes begin popping in it all gridlike. The brain-shaped rock reforms into a grate. You can see through it. There's a bare cave beyond. But you weren't born yesterday. You know to listen for growling, but when you don't hear it, you worry there might be a really really sneaky bear in there.[paragraph break]A familiar voice. 'Oh! You made it! Impressive, I guess. Not as much to do as the Compound Evein the Mind Grate shouldn't be too bad. I bet there are lots of ways around you. You did...okay enough. Helped us find a few holes in our process. Next lucky place'll have it better. Well, have a nice life.' You look around, but the [bad-guy-pc] is nowhere to be seen."
Ache Mist	--	"[b-m-m]'Old pain. Whether or not you relive it, it cripples you. I have some of that too. But I get over it a bit quicker.'"
Eerie Mist	--	"[b-m-m]'Stuff you asked WHY about, here. When other people just got out and did obvious things. Well, I guess it's worth it for you, if you think it is.'"
Rust Mist	--	"[b-m-m]'Bad advice. Deliberate. People you thought were just helping out, but you found they weren't. Or maybe they trusted YOU to be open to their help, and you failed them.'"
Old Mist	--	"[b-m-m]'Bad advice from peers. They didn't know any better. But if you were so smart, you should have known that.'"
Bare Cave	--	"Written in the dirt is THE RETURN OF NO POINT. You quickly wipe it out with your shoe, but you can't shake that you didn't do all that much. You turn around to leave, since you don't see anything, but tucked in the corner is a pod. It's labeled PEOPLE POD."

to say b-m-m:
	say "The [bad-guy-pc]'s voice from the mist: "

this is the trees-wood rule:
	now trees are in bees wood;

this is the trees-copse rule:
	now trees are in a feel copse;

this is the got-first-puz rule:
	if number of firstpuzzly things carried by Alec Smart is 0:
		say "You feel foreboding that you didn't come prepared. You're empty-handed, and maybe you could've [if delta is visited]taken something from the Delta[else]looked around the west a bit more[end if].";
	now default-turn-count is turn count;

this is the grate-place rule:
	set the pronoun it to mind grate;

this is the delta-drop rule:
	now jars of jars are in delta of delta;
	now solution of solution is in delta of delta;
	now bottle of bottle is in delta of delta;
	say "The washing water uncovers something odd--a reaction chain! It's rather shiny, and you react to its presence by grabbing at it. This creates a huge current, which sweeps the chain away. When you get back to shore, you notice something has washed up.[paragraph break]Well, three things: a bottle, some solution, and jars.";

[A Reaction Chain is a thing.]

volume pondering

There is a region called pondering.

check going when mrlp is pondering:
	say "You try to step out of the mist. Fortunately, it's not as dense as it seemed. You wind up back at Purposes Cross, beside the Disappointment Terminal.";
	move Alec to purposes cross;

to say x-z:
	say ". You can just EXIT, here, or you can wait around to confront old feelings"

instead of exiting when mrlp is pondering:
	try going north instead;

book Ache Mist

Ache Mist is a room in pondering. "You feel the pain of having made the wrong choices and not being able to make the right ones[x-z]."

mist-sc is privately-named unflip scenery. understand "mist" as mist-sc when mrlp is pondering. "It's hard see through[if alec is in rust mist], and it's reddish to boot[end if]."

ache-index is a number that varies.

every turn when Alec is in ache mist:
	increment ache-index;
	choose row ache-index in table of acheies;
	say "A man walks by and introduces himself as Lee [my1 entry]. After a brief one-sided conversation, he recedes into the mist, leaving you feeling [my2 entry].";
	if ache-index is number of rows in table of acheies:
		say "[line break]There ... can't be any more, can there? It was character-building. You hope.";
		now ache-index is 0;

table of acheies
my1	my2
"Bell"	"fat"
"Babb"	"untalkative and unsocial"
"DeVine"	"sacreligious"
"Dahl"	"un-macho"
"Gigg"	"unfunny"
"Miner"	"insignificant"
"Ho"	"unspiritual"
"Eid"	"lazy"
"Ruff"	"harrassed"
"Elder"	"juvenile"

book Old Mist

Old Mist is a room in pondering. "You feel the pain of realizing adults were wrong, even when they didn't want to mislead you[x-z]."

old-index is a number that varies.

every turn when Alec is in old mist:
	increment old-index;
	choose row old-index in table of oldies;
	say "A man walks by and introduces himself as Les [my1 entry]. After a brief one-sided conversation, he recedes into the mist, leaving you feeling [my2 entry], wondering if he meant to disorient you.";
	if old-index is number of rows in table of oldies:
		say "[line break]There ... can't be any more, can there? It was character-building. You hope.";
		now old-index is 0;

table of oldies
my1	my2
"Peer"	"inferior"
"Price"	"inferior"
"Self"	"greedy"
"Luck"	"overprivileged"
"Payne"	"hurt"
"Tiller"	"adrift"
"Worth"	"unvaluable"
"Ruth"	"unfocused"
"Law"	"repressed"
"Topp"	"skeevy"

book Eerie Mist

Eerie Mist is a room in pondering. "You feel the malaise of knowing there are a lot of things you'll never know, and even of what you do know not meaning much[x-z]."

eerie-index is a number that varies.

every turn when Alec is in eerie mist:
	increment eerie-index;
	choose row eerie-index in table of eerieies;
	say "A man walks by and introduces himself as Enos [my1 entry]. You chat a bit and realize how little you know about [my2 entry]. He excuses himself and disappears.";
	if eerie-index is number of rows in table of eerieies:
		say "[line break]There ... can't be any more, can there? It was character-building. You hope.";
		now eerie-index is 0;

table of eerieies
my1	my2
"Brayne"	"using intelligence practically"
"Stock"	"working out"
"Swank"	"taste and style"
"Leary"	"skepticism"
"Nift"	"conversational tricks"
"Happ"	"self-satisfaction"
"Feist"	"hanging in there"
"Kraft"	"do-it-yourself projects"
"Redd"	"preparing"
"Zaene"	"extreme comedy"

book Rust Mist

Rust Mist is a room in pondering. "You feel the malaise of knowing there are a lot of things you'll never know, and even of what you do know not meaning much[x-z]."

rust-index is a number that varies.

every turn when Alec is in rust mist:
	increment rust-index;
	choose row rust-index in table of rusties;
	say "A man walks by and babbles about his wonderful job at [my1 entry]Com. After a speil about being at the forefront of the modern age, and how you would be honored to work there, he dismisses you as simply not [my2 entry] enough even though you may be smart enough, but if you start caring about life, and about what people like him have to say, maybe... But he's a busy man! Off he goes.";
	if rust-index is number of rows in table of rusties:
		say "[line break]There ... can't be any more, can there? It was character-building. You hope.";
		now rust-index is 0;

table of rusties
my1	my2
"Passion"	"charitable"
"Pact"	"detail oriented"
"Raid"	"friendly"
"Plain"	"assertive"
"Pact"	"succinct"
"Mend"	"encouraging"
"Bust"	"full-of-fire"
"Mode"	"number-one"
"Modify"	"materialistic"
"Fee"	"relaxing"

book xyzzying

xyzzying is an action applying to nothing.

understand the command "xyzzy" as something new.
understand "xyzzy" as xyzzying.
understand the command "plugh" as something new.
understand "plugh" as xyzzying.
understand the command "plover" as something new.
understand "plover" as xyzzying.

xyzzyed is a truth state that varies.

carry out xyzzying:
	if bluff is visited and grate is in bluff:
		say "You'll need more than a magic word to get past the grate. An action, really." instead;
	if bare cave is visited or grate is in lalaland:
		say "You see yourself on a podium, being cheered as a champion, a victor." instead;
	if mrlp is pondering:
		say "You didn't need anything fancy to get back to Purposes Cross, but... this works anyway.";
		move Alec to Purposes Cross instead;
	if purposes cross is unvisited:
		say "You see a sort of mist--well, four, really. They seem far off. You both want to visit them later, and don't." instead;
	if ache mist is unvisited and old mist is unvisited and eerie mist is unvisited and Rust Mist is unvisited:
		say "You see yourself typing into the Disappointment Terminal [if Alec is not in purposes cross]back at Purposes Cross [end if]before going somewhere." instead;
	say "The disappointment terminal is the closest thing there is to a magic word in this game. Well, until the end. But that's another puzzle." instead;

volume Parting

Parting is a region.

book Bare Cave

Bare Cave is south of Way-Out Bluff. It is in Parting. description is "You feel pretty cool having found this cave! You can really only go back [b]OUT[r], so it must be the end of your journey."

check going outside in bare cave:
	try going south instead;

check exiting in bare cave:
	try going south instead;

check going south in bare cave:
	say "There's nothing to go back to. [if snowflake is in cave]Well, not that way. Your way home awaits[else]Surely the list panel won't, like, explode if you push the wrong button[end if]."
	
chapter people pod

the people pod is scenery in Bare Cave. description of People Pod is "It has a [activation of panelist]List Panel of letter/number combos from 0a to 10z. You can probably PUSH any one of them[one of], though you get [activation of panic button]button panic just looking at all 286 possibilities. So many wrong choices. So many right ones[or][stopping][if snowflake is not in bare cave]. One must be winning. You must be near the end[end if]."

check entering people pod:
	say "The pod isn't open, and perhaps you can [if snowflake is in bare cave]use the Snowflake instead[else]find a more comfortable mode of transportation[end if]." instead;

check opening people pod:
	say "You don't see how to." instead;

check taking people pod:
	say "Push one of the buttons on the list panel instead." instead;

section buttonpushing and main table

buttonpushing is an action applying to one topic.

understand "push [text]" as buttonpushing when Alec is in bare cave.
understand "press [text]" as buttonpushing when Alec is in bare cave.

carry out buttonpushing:
	repeat through table of final buttons:
		if topic understood matches the regular expression "\b[btn entry]":
			if there is no hit-yet entry or hit-yet entry is false:
				now hit-yet entry is true;
				if there is a btntalk entry:
					increment total-hits;
				check-flake-yay-hints;
			say "[btntalk entry][line break]";
			the rule succeeds;
	if the player's command matches the regular expression "\b(0|1|2|3|4|5|6|7|8|9|10)<a-z>$":
		say "Nothing happens when you push that button.";
		the rule succeeds;
	say "PUSH (NUMBER)(LETTER) is the command here, e.g. PUSH 3a.";
	the rule succeeds;

table of final buttons
btn	btntalk	hit-yet
"0a"	"You blink a bit, wondering if you missed part of a conversation."	false
"0b"	"You realize you haven't applied deodorant in a long time."
"0f"	"The [bad-guy-pc] briefly appears."
"0g"	"You feel impetus to, um, go."
"0h"	"You feel like a hype man is stirring you to action."
"0i"	"You resolve to understand programming in file streams a bit better."
"0j"	"Oh dear. Not here."
"0k"	"You look around, but nobody is about to throw a sneaky punch."
"0l"	"You feel in the dumps for a bit, but not long."
"0m"	"You feel you deserve more, if you put the effort in for it."
"0n"	"You get the feeling this was absolutely the wrong button to push."
"0o"	"You feel a need to groan a bit extra."
"0p"	"You feel upset and short of money."
"0s"	"You feel it doesn't all matter, for a minute."
"0t"	"You take a brief time out, much different from ordinary waiting."
"0w"	"You feel sad."
"0x"	"You feel more open to affection."
"0y"	"You feel more confident you can greet people hiply."
"1a"	"You feel extra spiffy about yourself."
"1b"	"You resolve to book up on Zen Buddhism when you get home."
"1c"	"You mutter 'See, I...' and figure out something that'd always been bugging you."
"1d"	"You feel mortality creeping up on you."
"1h"	"You feel like you're flying for a bit, but the feeling's a bit false."
"1i"	"[you-won]."	true
"1n"	"You imagine yourself playing basketball, getting fouled--and making the shot!"
"1p"	"You feel like snooping around to see if there's any pie to eat, but you realize you're overdoing it a bit."
"1r"	"You see, omentarily, how many people are connected in ways you didn't imagine. Then you forget that a bit later."
"1s"	"You overdo a sigh when nothing happens."
"1t"	"You ponder: no, this episode wasn't a tie. And it wasn't a loss."
"1u"	"[you-won]."	true	[this is a hack to make sure that the right button doesn't spawn hints]
"1w"	"[you-won]."	true
"1y"	"You look for reasons this was a positive experience."
"2b"	"You resolve to overdo something when you get home."
"2c"	"You resolve to see to certain things. What, you're not sure yet."
"2g"	"'Gee, to...' you think."
"2i"	"You vow to empathize much better with others."
"2m"	"You remember a childish argument, more funny now than then."
"2o"	"The air suddenly feels more breathable. You feel a rush."
"2r"	"You feel slightly more included."
"2u"	"No submarine appears. Nothing comes to you. But [if special is in bare cave]isn't one conveyance enough?[else]you felt like you were on to something. You still haven't found what you're looking for.[end if]"
"2y"	"You resolve not just to do things but look for a purpose."
"4b"	"You play through everything in your head again. All you were able to do. How things weren't completely sorted out, but they sort of were. You--you want to get back to where you were before, but you want to feel you...clinched the deal. No, something shorter than that."
"4c"	"You feel slightly more explosive."
"4e"	"You remember being told why you have to start with certain chess moves."
"4f"	"You contemplate playing a more aggressive chess opening when you get home."
"4o"	"You feel like you've done nothing for a bit, there[if snowflake special is in bare cave]. Well, since you summoned the Snowflake Special[else]. And you still haven't pushed a USEFUL button[end if]."
"4u"	"You suddenly consider a world where you had to be a moral beacon, with morals based on three virtues of truth, love and courage. But somehow, it seems like it could be very exciting."
"6c"	"You hope whatever transport there is, is not a boat."
"6d"	"You picture polyhedral dice spinning."
"6i"	"Some code floats into your head. You don't know the language well, but it makes sense what it's trying to do."
"6s"	"No portal to England appears."
"7i"	"Some code floats into your head. It reads almost like English in some places and makes almost immediate sense. Wow! Cool!"
"8b"	"You hear someone insulting you, but you realize you don't have to respond."
"8d"	"Your thoughts turn to romance."
"8f"	"You feel lucky to be who you are."
"8g"	"You see the vision of a gate, but it doesn't lead anywhere."
"8h"	"You feel a sense of rage."
"8i"	"You realize you HAVEN'T eaten anything, but you feel a greater hunger for...wait for it...self-fulfullment."
"8k"	"You see a girl."
"8l"	"Yes, it is late."
"8m"	"You see yourself making new friends, and rather easily at that."
"8n"	"You suddenly remember skills and talents you forgot you had."
"8r"	"You evaluate yourself a bit higher than before."
"8s"	"You feel as though you've had enough, in a good way."
"8u"	"You suddenly remember some of the best meals you ever had."
"8v"	"No vegetable drink appears."
"8w"	"You, err, wait, and nothing happens."
"9b"	"You feel harmless."
"9d"	"No, no, that's not it."
"9k"	"No dog appears."
"9y"	"You feel a need to complain."
"10a"	"You worry there's a military commander around the corner, ready to give orders."
"10b"	"You give up. Well, for the moment. There's no way to win, you didn't really win, and you're not going to win."
"10c"	"Alas, no chairs appear."
"10d"	"You picture polyhedral dice spinning."
"10e"	"Sadly, no meal, or even half-meal arrives. But hey, at least it wasn't a finished meal!"
"10l"	"You feel as though this adventure was a candle in the wind."
"10q"	"You feel slightly sexier than before."
"10t"	"You feel an urge to go mountain climbing."
"10x"	"You wish you could extend the adventure more, but you can't."
"10y"	"Your teeth feel slightly cleaner. Yay!"
[this is a silly hack to avoid regex matching and slowdown--so the 10* aren't superseded by 0*]

to say you-won:
	say "[if location of snowflake special is bare cave]The Snowflake Special doesn't budge[else]You hope this is the way back to where you were before. You hear a whirring from an unseen tunnel, then POP! A weird vehicle appears. It's labeled SNOWFLAKE SPECIAL[end if][snoflak]"

to say snoflak:
	dump-snowflake;

to dump-snowflake:
	if snowflake special is not in bare cave:
		increment the score;
	move snowflake special to bare cave;

section flake hints

total-misses is a number that varies. total-hits is a number that varies.

to check-flake-yay-hints:
	increment total-hits;
	repeat through table of flake-yay hints:
		if total-hits >= wrong-buttons entry and got-yet entry is false:
			now got-yet entry is true;
			if snowflake is in bare cave:
				say "It's lots of fun to try new buttons, and there's no rush. Whee.[line break]";
				continue the action;
			say "[yay-hint entry][paragraph break]";

table of flake-yay hints
wrong-buttons	got-yet	yay-hint
19	false	"None of the buttons really has felt like a winner yet."
15	false	"You've had enough to zap one letter, if you just focused on brute force. But you feel like you can do better."
11	false	"None of the buttons seems to lose yet."
7	false	"You consider if maybe certain numbers are particularly useless, or some letters are. That could cut down."
3	false	"Hm, no buttons have exploded yet. But there has to be trial and error."

to check-flake-boo-hints:
	increment total-misses;
	repeat through table of flake-boo hints:
		if total-misses is wrong-buttons entry:
			if snowflake is in bare cave:
				say "You look over at the Snowflake Special. No, it won't go anywhere, no matter how many boring buttons you push.";
				continue the action;
			say "[boo-hint entry][line break]";

table of flake-boo hints
wrong-buttons	boo-hint
2	"There are a lot of letters and numbers you can probably discount immediately. Maybe if you get a few right, you can get a lead on which button works well."

chapter snowflake special

rule for supplying a missing noun when entering:
	if player is in cave and snowflake is in cave, now noun is snowflake

the Snowflake Special is a thing. "The Snowflake Special waits here for you to enter it and go home, though there's no rush.". description is "The Snowflake Special is an oddly shaped conglomeration of slightly warped hexagonal panels. [one of](They couldn't be straight. That'd be a planar tiling.) [or][stopping]It's open, and you probably just want to leave, though poking more buttons on the People Pod wouldn't be fatal. You hope."

understand "train/ss" as snowflake special when player is in cave and snowflake is in cave

check pushing snowflake:
	say "It'll run fine if you just ENTER it." instead;

understand "weird/vehicle" and "weird vehicle" as snowflake special.

check taking snowflake special:
	say "It's too heavy to pick up, but if you actually want to take it home, type IN or ENTER." instead;

check entering Snowflake Special:
	say "The ride back is smooth. There's Crazy Drive, where people deliberate whether or not Alec Smart REALLY did it out of the goodness of your heart. Or whether it was a bit greedy to have another shot at it, or if he is going to brag too much about what he did, or not use his experience well enough. And of course the [bad-guy-pc] saying you didn't win MUCH, you know. And if you didn't have fun, why bother, and if you did, you're really sort of lame. But you recognize that as posturing. You did get rid of the stupid net and prints and auto. And you dealt with a few more humbugs. That's good enough for now.";
	win-the-game;
	end the story finally saying "Someone Won Some!";
	the rule succeeds;

check going inside when Alec is in bare cave:
	if snowflake special is in bare cave:
		try entering snowflake special instead;

does the player mean entering the snowflake special:
	it is very likely;

book Way-Out Bluff

Way-Out Bluff is below Purposes Cross. It is in Parting. "[one of]After a long walk, you wind up near a small hillside. There's a weird rock, shaped like a brain, slightly out of place among the more generic rocks to the south[or]Purposes Cross is a long way back up! But that cave inside to the south isn't. At least, you think and hope it's bare[if mind grate is in way-out bluff], behind that mind grate blocking it[end if][stopping]."

check going up in way-out bluff:
	say "You think about going back over Bull Gully, to prove that you're not scared, but then you get extra scared you might get punked, and that'd be really embarrassing.[paragraph break]Besides, that [if grate is in bluff]grate[else]cave[end if] seems more interesting anyway." instead;

check going south in way-out bluff:
	if mind grate is in bluff:
		say "That mind grate might be electric! And, well, you know what might be in that (seemingly) bare cave. It might be...beyond great. But why risk it?" instead;

check going inside in way-out bluff:
	try going south instead;

the mind grate is scenery in Way-Out Bluff. "It's a gridwork of energy bars, like you remember from Saturday morning cartoons. There doesn't seem to be any switch to shut it off, but harkening to the morals of Saturday morning cartoons, you suspect the power to get rid of it IS INSIDE OF YOU. But what to do to the grate?"

check taking the mind grate:
	say "You aren't sure how to get a good grip on it. Plus if you tried to carry it into Bear Cave, it'd hit against the entryway. No. You have to do something to destroy it." instead;

volume meta

book odd verbs

chapter abouting

abouting is an action out of world.

understand the command "about" as something new.

understand "about" as abouting.

carry out abouting:
	say "Slicker City is a sequel to my IFComp 2015 effort, The Problems Compound. It features Alec Smart about four years later as a college student. He has new challenges and so forth. It has the same sort of whimsical mechanic, but it's a lot shorter, and I hope there's a good and serious and positive message in it. You don't need to have played PC to understand it.[paragraph break]SC came about when I was running up to the IFComp 2015 deadline and the phrase 'city slicker' stuck in my mind. So I dumped the good tries I knew wouldn't make it in a Trizbort file, which grew and slowly got organized. Though around August it got so big that I needed to cut SC down and punt to another game with a new protagonist. Maybe that will be for 2017.";
	say "[line break]CREDITS tells who helped with this game.";
	the rule succeeds;

chapter creditsing

creditsing is an action out of world.

understand the command "credits" as something new.

understand "credits" as creditsing.

carry out creditsing:
	say "Hugo Labrande, Adri, Skinny Mike, Chandler Groover, Ham Salad, Vince Laviano, Felicity Banks and Skarn (listed in random order) tested the game at various stages before release and helped me avoid some embarrassing bugs. I also used Zarf's testing framework to weed out other bugs and check off on regressions.";
	say "[line break]Thanks to Hugo Labrande and Alex Butterfield for our games of code tennis, which is basically, try and do something every other day, or the other guy scores a point. Alex worked with me more on our IFComp 2015 post-release efforts, but since SC is the sequel to PC, a lot of things I pinged him with were relevant here. So I recommend this simple exercise to anyone who wants to write a game but who needs outside motivation. Synergy and all that.";
	say "[line break]More generally, I want to add I've been able to connect with a lot of cool people in the author's forum and who've sent transcripts, over the years. Working together on stuff is fun, and if you're a judge or just playing a game, I recommend you send a transcript or even help test beforehand. It helps the community, well, be a community. You get to see how games are made, and you get to see that other writers have their own roadblocks they can overcome. And this has motivated me to write, whether it's a text adventure or more straightforward fiction.";
	the rule succeeds;

chapter verbing

verbing is an action out of world.

understand the command "v/verb/verbs" as something new.

understand "v" as verbing.
understand "verb" as verbing.
understand "verbs" as verbing.

carry out verbing:
	say "[2da]The main directions are north, south, east and west ([b]N/S/E/W[r]). Diagonals aren't used after the intro, and they're never necessary. You can go in or out, too, and occasionally up or down.";
	say "[2da][b]USE[r] something [b]ON[r] something is an all-purpose verb because I wanted to make things simpler for the player. And for me, programming. Hey, win-win.";
	if rock-furn is true and furniture is not in lalaland:
		say "[2da][b]PUSH[r] the Furniture.";
	say "[2da][b]TAKE[r] or [b]EXAMINE[r] things ([b]X[r] for short).";
	say "[2da][b]LISTEN[r] may provide small clues.";
	say "[2da][b]THINK[r] and [b]SCORE[r] may provide general clues.";
	if score < 5:
		say "[2da]There's two verbs you'll have to figure as part of a puzzle, but don't worry, there'll be clues and maybe even alternate solutions.";
	else if score < 10:
		say "[2da]There's one more verb to figure as part of a puzzle, but don't worry, there are several alternate solutions.";
	say "[2da][b]META[r] shows meta-commands not critical to the story, and [b]OPTS/OPTIONS[r] shows small commands to toggle.";
	if in-beta is true:
		say "[line break]JUMP COMMANDS YOU CAN USE[if cadet space is visited] IF YOU RESTART[end if]:[line break]";
		say "[2da]TOUCH COMMON, CROSS DOUBLE, and WOOF AND WARP (WAW/WW)."

chapter metaing

metaing is an action out of world.

understand the command "meta" as something new.

understand "meta" as metaing.

carry out metaing:
	say "Meta-commands:[line break]";
	say "[2da][b]XP/EXPLAIN[r] explains the semantic joke behind an item or person or place.";
	say "[2da][b]ABOUT[r], [b]CREDITS[r], [b]HISTORY[r] and [b]TECH[r] are meta-commands that give an overview of the game and thanks to people and websites and programs that helped in it.";
	say "[2da]DIF ([on-off of pc-dif]) toggles showing differences between Problems Compound and Slicker City and points out 'recycled' items.";
	the rule succeeds;

chapter optsing

optsing is an action applying to nothing.

understand the command "opts" as something new.
understand the command "options" as something new.

understand "opts" as optsing.
understand "options" as optsing.

carry out optsing:
	say "There are a few trivial options for Slicker City:[line break]";
	say "[2da][b]LANG[r] toggles (very) minor innuendo, currently [on-off of swears].";
	say "[2da][b]ACCESS[r] toggles screenreader mode, currently [on-off of screenread].";
	say "[2da][b]DIF[r] toggles annotation with Problems Compound, currently [on-off of pc-dif].";
	the rule succeeds;

chapter historying

historying is an action out of world.

understand the command "history" as something new.

understand "history" as historying.

carry out historying:
	say "Slicker City came about around September 20, 2015, when I was frantically trying to close up The Problems Compound. I started seeing ideas which seemed great, but not for that game. Just the name, Slicker City, suggested somewhere else mysterious to be, and I started drawing up the Trizbort map of locations that didn't quite fit. The side ideas from Problems Compound popped up and added to SC here and there. I made scripts.";
	the rule succeeds;

chapter teching

teching is an action out of world.

understand the command "tech" as something new.

understand "tech" as teching.

carry out teching:
	say "http://www.learn-english-today.com was VERY useful.";
	say "http://en.wiktionary.org was VERY useful.";
	say "http://idioms.thefreedictionary.org was VERY useful.";
	say "All manner of PERL tricks helped.";
	say "Github was handy for Problems Compound. BitBucket was handy for Slicker City while I had to keep it private.";
	the rule succeeds;

volume inaccessible

inaccessible is a region.

lalaland is a privately-named room in inaccessible.

understand "lll/lalaland" as lalaland when debug-state is true.

the Baiter Master is a person. description is "bug".

the Town Ghost is a person. description is "bug".

volume out of world verbs

chapter annoing

anno-allow is a truth state that varies.

ever-anno is a truth state that varies.

anno-check is a truth state that varies.

annoing is an action out of world.

understand the command "anno" as something new.

understand "anno" as annoing.

carry out annoing:
	if anno-check is false:
		say "NOTE: if you haven't solved Problems Compound, or certain parts, this may work as a spoiler. Say yes to make sure that you want to go through with it. This nag will not appear if you wish to toggle annotations again.";
		if the player yes-consents:
			now anno-allow is true;
		now anno-check is true instead;
	now anno-allow is whether or not anno-allow is false;
	now ever-anno is true;
	say "Now annotations are [if anno-allow is true]on[else]off[end if].";
	[showme whether or not anno-allow is true;] [commented this code for later reference. It's handy.]
	the rule succeeds;

cur-anno is a number that varies. cur-anno is usually 0.

section the triggers

after printing the locale description (this is the show annos rule):
	if anno-allow is true:
		let myloc be location of Alec;
		repeat through table of annotations:
			if myloc is anno-loc entry:
				if anno-num entry is 0:
					increment cur-anno;
					say "([cur-anno]) [anno-long entry]";
					now anno-num entry is cur-anno;
				continue the action;
	continue the action;

after examining:
	if anno-allow is true:
		if noun is an exam-thing listed in table of annotations:
			choose row with exam-thing of noun in table of annotations;
			if anno-num entry is 0:
				say "([cur-anno]) [anno-long entry]";
				increment cur-anno;
				now anno-num entry is cur-anno;

chapter difing

difing is an action out of world.

understand the command "dif" as something new.

understand "dif" as difing.

carry out difing:
	now pc-dif is whether or not pc-dif is false;
	say "Noting Problems Compound recycling is now [on-off of pc-dif].";
	the rule succeeds;

[the show recycling rule is listed after the show annos rule in the printing the locale description rules.]

chapter swearing

swearing is an action out of world.

understand the command "lang" as something new.

understand "lang" as swearing.

carry out swearing:
	now swears is whether or not swears is false;
	say "Minor innuendo is now [on-off of swears].";
	the rule succeeds;

chapter accessing

accessing is an action out of world.

understand the command "access" as something new.

understand "access" as accessing.

carry out accessing:
	now screenread is whether or not screenread is false;
	say "Screen reader mode is now [on-off of screenread].";
	the rule succeeds;

[the show recycling rule is listed after the show annos rule in the printing the locale description rules.]

section retro anno

after printing the locale description:
	if location of Alec is retro-anno and pc-dif is true:
		now location of Alec is not retro-anno;
		if location of Alec is not a rmname listed in table of retro annos:
			say "This should be annotated as something taken from The Problems Compound, but it isn't.";
		else:
			choose row with rmname of location of Alec in table of retro annos;
			say "[i][bracket]NOTE: [rmanno entry][close bracket][r][line break]";

to ital-say (x - indexed text):
	say "[i][bracket]NOTE: [x][close bracket][r]";

table of retro annos
rmname	rmanno
Purposes Cross	"The Purposes Cross was formerly advice on How to Snark in The Problems Compound. It got changed to the Saver Screen at the start of release 2, and I added many random entries. Then just before release I realized it'd be better as the Basher Bible."

section the table

table of annotations [toa]
anno-num	exam-thing	anno-loc	anno-short (text)	anno-long (text)
0	Alec Smart	That Thought Park	"park"	"Of course, this sort of park is good for making your mind wander, while Park That Thought means the opposite. This is the first room in the game but the last of the woods I thought of. Of which I thought."
0	--	Bees Wood	"bees"	"As a kid I remember a music video by Scritti Politti (more famous for Perfect Way) called Wood Beez. The name always stuck with me, and it wasn't til I realized my initial game start was a horrid text dump that I conceived of a way through the forest. This was the first name."
0	--	A Feel Copse	"copse"	"I originally had A Feel Cop in the Sinister Bar (Soda Club) in The Problems Compound. But it has less 'eww' potential as something inanimate. My feelings are that it's easy to look bold writing about sexuality, but I don't think that's the most productive use of our feelings."

chapter exitsing

exitsing is an action out of world.

understand the command "exits" as something new.

understand "exits" as exitsing.

carry out exitsing:
	if mrlp is preamble:
		say "You can go pretty much any which way, other than up or down." instead;
	if number of viable directions is 1:
		say "The only exit is [random viable direction].";
	else:
		say "Exits are to the [list of viable directions].";
		repeat with Q running through viable directions:
			say "[2da][Q]: [the room Q of location of Alec][line break]";
	the rule succeeds;

definition: a direction (called myd) is viable: [kep track of "special" passages]
	if the room myd of location of Alec is nowhere, decide no;
	if Alec is in Purposes Cross:
		if myd is inside:
			decide no;
		if myd is down:
			decide no;
	decide yes;

volume ending jazz

Procedural rule: ignore the print final score rule.

volume concepts

chapter conceptville and concept definitions

conceptville is a privately-named room in inaccessible. [concepts you don't know are here]

understand "conceptville/cv" as conceptville when debug-state is true.

a concept is a kind of thing. description of a concept is usually "[bug]"

a concept has text called howto. howto of a concept is "(need text)".

a concept can be explained. a concept is usually not explained.

section move concepts over

to say activation of (x - a thing):
	now x is in lalaland;

book all the concepts [xxcv]

section general stub

to say f-t of (rr - a room):
	say "visit [rr] for the first time"

section general concepts

Bust a Move is a concept in conceptville. howto is "wait in the city proper".

double take is a concept in conceptville. howto is "CROSS DOUBLE or TOUCH COMMON twice".

Fine tuning is a concept in conceptville. Understand "tuning fine" as fine tuning. howto is "sing".

Lame Duck is a concept in conceptville. Understand "duck lame" as lame duck. howto is "say a mild curse word like drat".

Not Your Type is a concept in conceptville. howto is "Type (or not) an empty command".

Nothing doing is a concept in conceptville. Understand "doing nothing" as nothing doing. howto is "wait in the city proper".

rubbish tip is a concept in conceptville. Understand "tip rubbish" as rubbish tip. howto is "try for a HINT".

Type O Negative is a concept in conceptville. Understand "oh negative type" as Type O Negative. howto is "say no".

Type O Positive is a concept in conceptville. Understand "oh positive type" as Type O Positive. howto is "say yes".

whale of a time is a concept in conceptville. Understand "time a of whale" as whale of a time. howto is "cuss once or twice".

section actual concepts

[these are mostly revealed as you go through the game]

chapter procrastination concepts

section known

Mondegreen is a concept in lalaland. Understand "green monde" and "monde green" as mondegreen. howto is "play the game".

Slicker City is a concept in lalaland. Understand "city slicker" as Slicker City. howto is "play the game"

two-bit is a concept in lalaland. Understand "two bit" and "bit two" as two-bit. howto is "play the game".

section that thought park

rigidly is a concept in conceptville. Understand "idly rig" and "rig idly" as rigidly. howto is "[f-t of That Thought Park]".

section bees wood

augment is a concept in conceptville. Understand "meant augh" and "augh ment" as augment. howto is "[f-t of Bees Wood]".

section a feel copse

to say no-master:
	say "decline the [bad-guy-pc]'s help"

banality of evil is a concept in conceptville. Understand "evil of banality" as banality of evil. howto is "[no-master]".

figurehead is a concept in conceptville. Understand "figure head" and "head figure" as figurehead. howto is "[no-master]".

forbidden is a concept in conceptville. Understand "bidden for" and "for bidden" as forbidden. howto is "[f-t of A Feel Copse]".

Stunt Double is a concept in conceptville. Understand "double stunt" as stunt double. howto is "Talk to the [bad-guy-pc]".

section cadet space

token of appreciation is a concept in conceptville. Understand "appreciation of token/tokens" and "tokens of appreciation" as token of appreciation. howto is "put the token in the protector".

token resistance is a concept in conceptville. Understand "resistance token" as token resistance. howto is "Search the furniture in Cadet Space".

town square is a concept in conceptville. Understand "square town/village" and "village square" as town square. howto is "decline the [bad-guy-pc]'s initial request".

section sense common

check in is a concept in conceptville. Understand "in check" as check in. howto is "visit Crazy Bureau for the first time.".

section Crazy Bureau

backstab is a concept in conceptville. Understand "back stab" and "stab back" as backstab. howto is "go to Sense Common for the first time".

section purposes cross concepts

gullible is a concept in conceptville. Understand "gullible" as gullible. howto is "[f-t of Purposes Cross]".

chapter partnership concepts

section comedy-club concepts

comedy club is a concept in conceptville. Understand "club comedy" as comedy club. howto is "[f-t of comedy-club]".

section Instinct Base

section snipe gutter

zeho is a privately-named concept in conceptville. printed name is "Zero Hour". Understand "our/hour zero" and "zero our/hour" as zeho. howto is "[f-t of Snipe Gutter]".

section Lent-You-Corp

sober is a concept in conceptville. Understand "er sob" and "sob er" as sober. howto is "[f-t of Lent-You-Corp]".

chapter profit concepts

section profit turn concepts

business instinct is a concept in conceptville. Understand "instinct business" as business instinct. howto is "[f-t of Profit Turn]".

section handshake firm concepts

section production peak

claptrap is a concept in conceptville. Understand "clap trap" and "trap clap" as claptrap. howto is "[f-t of production peak]".

chapter popularity concepts

section way of right concepts

section something institute concepts

section ego altar concepts

section motive base concepts

section perception altar concepts

section bust row

section Player Roll concepts

section bare cave

section instincts base

chapter power concepts

section jungle of law

nuance is a concept in conceptville. Understand "nuance" as nuance. howto is "[f-t of Jungle of Law]".

chapter Parting concepts

section events current

section Grosser Green

section Back Quarter

section way-out bluff

point of no return is a concept in conceptville. Understand "point of no return" as point of no return. howto is "[f-t of way-out bluff]".

section bare cave

panelist is a concept in conceptville. understand "list panel" and "panel list" as panelist. howto is "examine the people pod"

panic button is a concept in conceptville. understand "button panic" as panic button. howto is "examine the list panel"

volume endgame

to win-the-game:
	choose row with final response activity of amusing a victorious player in table of final question options;
	now final question wording entry is "see suggestions for [bi of amuse-seen]AMUSING[r] things to try";

[xxend]

Table of Final Question Options (continued)
final question wording	only if victorious	topic	final response rule	final response activity
"see reversible [bi of concepts-seen]CONCEPTS[r] you missed (or [bi of all-seen]ALL[r])"	true	"CONCEPTS"	concept-see rule	conceptseeing
--	true	"ALL"	concept-all rule	conceptseeing
"see where minor [bi of swear-seen]SWEARS[r] tweak things"	true	"SWEARS"	swear-see rule	swearseeing
"see areas [bi of missed-seen]MISSED[r] this time around"	true	"MISSED"	missed-see rule	missseeing
"see [bi of jump-seen]JUMP[r] commands for replaying the game but skipping already-done parts"	true	"JUMP"	jump-see rule	jumpseeing
"explain names of [bi of room-seen]ROOMS[r] or [bi of thing-seen]THINGS[r] in Slicker City"	true	"ROOMS"	room-see rule	roomseeing
--	true	"THINGS"	thing-see rule	thingseeing

to decide whether got-all-meta:
	if amuse-seen is false, decide no;
	if swear-seen is false, decide no;
	if concepts-seen is false, decide no;
	decide yes;

to say bi of (ts - a truth state):
	if screenreader is true:
		if ts is true:
			say "* ";
	else:
		say "[if ts is true][i][else][b][end if]"

the print the modified final question rule is listed before the print the final prompt rule in before handling the final question.

the print the final question rule is not listed in any rulebook.

to decide whether alec-won:
	(- story_complete == true -);

to say bold-asterisk:
	say "[if screenreader is true]Asterisked[else]Bolded[end if]";

This is the print the modified final question rule:
	unless alec-won:
		say "Alec didn't REALLY make a successful ending, so all you can do is RESTART, RESTORE a saved game, QUIT, or UNDO.";
		continue the action;
	let named options count be 0;
	repeat through the Table of Final Question Options:
		if the only if victorious entry is false or the story has ended finally:
			if there is a final response rule entry
				or the final response activity entry [activity] is not empty:
				if there is a final question wording entry, increase named options count by 1;
	if the named options count is less than 1, abide by the immediately quit rule;
	say "[if got-all-meta]You can look through any of these again if you want[else]Here is game information you may find interesting or amusing. [bold-asterisk] means not seen yet[end if].";
	let pure-metas be 0;
	repeat through the Table of Final Question Options:
		if the only if victorious entry is false or the story has ended finally:
			if there is a final response rule entry
				or the final response activity entry [activity] is not empty:
				if there is a final question wording entry:
					if there is a final response activity entry:
						say "[2da][final question wording entry][line break]";
					else:
						increment pure-metas;
	say "[line break]You can also ";
	repeat through the Table of Final Question Options:
		if the only if victorious entry is false or the story has ended finally:
			if there is a final response rule entry
				or the final response activity entry [activity] is not empty:
				if there is a final question wording entry:
					unless there is a final response activity entry:
						decrement pure-metas;
						say "[if pure-metas is 0]or [end if][final question wording entry][if pure-metas is 0].[else], [end if]";
	say "[line break]";

amuse-seen is a truth state that varies. amuse-seen is false.

rule for amusing a victorious player:
	let count be 0;
	if number of rows in table of amusements > 10:
		say "[q-quit]";
	repeat through table of amusements:
		if there is a show-rule entry:
			consider the show-rule entry;
			if the rule failed:
				next;
		say "[2da][laffy entry]";
		increment count;
		if the remainder after dividing count by 10 is 0 and count < number of rows in table of amusements:
			consider the should-quit rule;
			if the rule succeeded:
				the rule succeeds;
	now amuse-seen is true;

table of amusements
laffy	show-rule
"XYZZY?"	a rule
"STRIP COMIC in [comedy-club]?"	shock-vis rule
"CLUB COMEDY in [comedy-club]?"	shock-vis rule
"TIED ROLL in Lent-You-Corp?"	lou-vis rule
"BILL TERRY in the Snipe Gutter?"	snipe-vis rule

jump-seen is a truth state that varies. jump-seen is false

jumpseeing is an activity.

this is the jump-see rule:
	say "[2da]--if you [b]TOUCH COMMON[r], you can jump to Sense Common with the Tiger Paper in hand.";
	say "[2da]--if you [b]CROSS DOUBLE[r], you can jump to Purposes Cross. The game will prompt you for which Delta item you wish to take (B/J/S/X=exit, N=none).";
	now jump-seen is true;

swearseeing is an activity.

swear-seen is a truth state that varies.

this is the shock-vis rule:
	if comedy-club is visited:
		the rule succeeds;

this is the lou-vis rule:
	if Lent-You-Corp is visited:
		the rule succeeds;

this is the snipe-vis rule:
	if snipe gutter is visited:
		the rule succeeds;

this is the swear-see rule:
	let count be 0;
	if number of rows in table of sweardifs > 10:
		say "[q-quit]";
	repeat through table of sweardifs:
		say "[2da][diffy entry][line break]";
		increment count;
		if the remainder after dividing count by 10 is 0 and count < number of rows in table of sweardifs:
			consider the should-quit rule;
			if the rule succeeded:
				the rule succeeds;
	now swear-seen is true;

to say l-ju:
	say "are maybe in the Life Shelf or Book Jungle"

table of sweardifs
diffy
"The [bad-guy-pc] is [stwid][bad-guy-pc][stwid] instead, and [vbad-pc] is [stwid][vbad-pc][stwid] instead."
"[comedy-club] is [stwid][comedy-club][stwid] instead."
"The jokes in [comedy-club] are also different."

room-seen is a truth state that varies.

thing-seen is a truth state that varies.

roomseeing is an activity.

thingseeing is an activity.

missseeing is an activity.

this is the room-see rule:
	let count be 0;
	say "[q-quit]";
	repeat through table of room explanations:
		say "[b][room-to-exp entry][r]: [exp-text entry][line break]";
		increment count;
		if the remainder after dividing count by 10 is 0:
			wfak;
	now room-seen is true;

this is the thing-see rule:
	let count be 0;
	say "[q-quit]";
	repeat through table of explanations:
		say "[b][exp-thing entry][r]: [exp-text entry][line break]";
		increment count;
		if the remainder after dividing count by 10 is 0:
			wfak;
	now thing-seen is true;
	
missed-seen is a truth state that varies.

this is the missed-see rule:
	now missed-seen is true;
	if bottle is in delta or bottle is off-stage:
		say "[2da]The Bottle would've let you into the comedy club northeast of Purposes Cross.";
	if solution is in delta or solution is off-stage:
		say "[2da]The Solution would've let you into the underground area below the Jungle of Law and Profit Turn.";
	if jars are in delta or jars are off-stage:
		say "[2da]The Jars would've let you into the gutter southeast of Purposes Cross.";
	let mists-visited be number of unvisited rooms in Pondering;
	if mists-visited > 0:
		say "[2da]there [if mists-visited is 1]was one[else]were [mists-visited in words][end if] [if mists-visited is 0]rooms[else if mists-visited is 3]mist[else]mists[end if] you could've visited via the Disappointment Terminal.";
	let first-item be true;
	repeat through table of grate tries:
		if winner entry is true and did entry is false:
			if first-item is true:
				say "[2da]Other ways to dispel the grate: [wordtry entry]";
				now first-item is false;
			else:
				say "/[wordtry entry]";
	say "[line break]";
	now first-item is true;
	repeat through table of grate tries:
		if winner entry is false and did entry is false:
			if first-item is true:
				say "[2da]Grate 'good try': [wordtry entry]";
				now first-item is false;
			else:
				say "/[wordtry entry]";
	if first-item is false:
		say "[line break]";		
	say "[line break]You can, on replay, use the command TOUCH COMMON to skip past the Change Chump and start with the tiger paper, if you want to see the other two ways through.";

conceptseeing is an activity.

concepts-seen is a truth state that varies.

all-seen is a truth state that varies.

see-all-concepts is a truth state that varies.

this is the concept-all rule:
	now see-all-concepts is true;
	consider the concept-see rule;
	now see-all-concepts is false;
	the rule succeeds;

this is the concept-see rule:
	let count be 0;
	now concepts-seen is true;
	if see-all-concepts is true:
		now all-seen is true;
	if number of concepts in conceptville > 10 or see-all-concepts is true:
		say "[q-quit]";
	repeat with X running through concepts:
		if see-all-concepts is true or X is in conceptville:
			choose row with exp-thing of X in table of explanations;
			say "[b][X][r]: [exp-text entry] ([howto of X])[line break]";
			increment count;
			if the remainder after dividing count by 10 is 0:
				consider the should-quit rule;
				if the rule succeeded:
					the rule succeeds;
	if count is 0:
		say "Oops, you got all the concepts. Awesome work!";
	now concepts-seen is true;
	the rule succeeds;

to say q-quit:
	say "Printing them ten at a time. Type Q to quit.[paragraph break]"

this is the should-quit rule:
	if debug-state is true, the rule succeeds;
	let Q be the chosen letter;
	if Q is 81 or Q is 113:
		the rule succeeds;

volume gotoing

chapter going to

understand the command "go to" as something new.
understand the command "goto" as something new.
understand the command "gt" as something new.

gotoing is an action applying to one thing.

understand "goto [any room]" as gotoing.
understand "go to [any room]" as gotoing.
understand "gt [any room]" as gotoing.

gotothinging is an action applying to one visible thing.

understand "goto [any thing]" as gotothinging.
understand "go to [any thing]" as gotothinging.
understand "gt [any thing]" as gotothinging.

a thing can be unchaseable. a thing is usually not unchaseable.

carry out gotothinging:
	let mrlg be map region of location of noun;
	if noun is off-stage or mrlg is nothing:
		say "[if noun is a person]They aren't[else]That isn't[end if] around right now." instead;
	if noun is unchaseable:
		say "Sorry, you'll have to find [if noun is a person]them[else]that[end if] on your own." instead;
	say "(going to [location of noun])[line break]";
	try gotoing location of noun instead;

carry out gotoing:
	let mrlg be map region of noun;
	if mrlg is nothing:
		say "Congratulations! You discovered an off-stage room. But I can't let you get there." instead;
	d "Trying location [noun].";
	if noun is location of Alec:
		say "You're already there. I mean, here." instead;
	if mrlg is preamble:
		say "No going back.";
	move Alec to noun;
	the rule succeeds;

volume mapping

book for in-game extension

table of map coordinates (continued)
rm	x	y	l1	l2	indir	outdir	updir	downdir
feel copse	0	6	"FEEL "	"COPSE" [start prelude]
bees wood	0	5	"BEES "	"WOOD "
that thought park	0	4	"THGHT"	"PARK "	north
cadet space	0	3	"CADET"	"SPACE" [start procrastination]
sense common	1	3	"SENSE"	"COMMN"
Back Quarter	1	2	"BACK "	"QUART"
Delta of Delta	1	4	"DELTA"	"DELTA"
Crazy Bureau	2	3	"CRAZY"	"BUREA"
purposes cross	3	3	"PURPS"	"CROSS"
comedy-club	4	2	"SHOCK"	"CULTR" [start partnership]
Lent-You-Corp	2	4	"COOL "	"LOUS "
profit turn	3	2	"PROFI"	"TURN" [start profit]
production peak	3	1	"PRODU"	"PEAK "
jungle of law	3	4	"JUNGL"	"O LAW"
protection cavity	4	6	"PROTE"	"CAVIT"
snipe gutter	4	5	"SNIPE"	"GUTTR"
way of right	4	3	"WAY O"	"RIGHT"
way-out bluff	6	1	"WAYOU"	"BLUFF"
lalaland	8	0	"====="	"=====" [start meta]
conceptville	8	1	"====="	"====="

book inform internal map

index map with bare cave mapped north of comedy-club.

index map with feel copse mapped north of cadet space.

index map with bees wood mapped north of feel copse.

index map with that thought park mapped east of bees wood.

index map with Lent-You-Corp mapped west of profit turn.

index map with ache mist mapped north of bees wood.

index map with eerie mist mapped east of ache mist.

index map with old mist mapped east of eerie mist.

index map with rust mist mapped east of old mist.

chapter preamble

chapter procrastination

chapter pondering

chapter profit

chapter power

chapter Parting

chapter partnership

chapter punishment

volume beta testing - not for release

book instructions

when play begins (this is the force tester wherever rule):
	now in-beta is true;
	if currently transcripting:
		say "It looks like you restarted, and the transcript should still be running.";
	else if debug-state is false:
		say "Note: I like to make sure beta testers have a transcript working. It's a big help to me. So, after you press a key, you'll be asked to save a file.";
		wfak;
		try switching the story transcript on;
		say "Transcripts can be sent to blurglecruncheon@gmail.com. Any punctuation before the comment should be caught, e.g. *TYPO or ;typo or :typo.";
	say "Below is a list of beta commands. This will not show up in the release ZIP (I'll test that). Push any key to see them.";
	wfak;
	say "There are three commands that can help testers jump over stuff they've already looked at:[paragraph break]TOUCH COMMON is a command that kicks you to the Common, and you can just go east twice to get to the main area. It will also be available in the release.";
	say "[line break]CROSS DOUBLE is a command that lets you choose what item you start to cheat with. It also may provide an alternate ending post-release.";
	say "[line break]WOOF AND WARP (WAW or WW) to get past Slicker City proper and get to the second-final room of the game, which has a lateral thinking puzzle.";
	say "[line break]Note: these don't work once you've hit the first 'proper' room of the game.";
	say "[line break]Also, THINK may give you a hint, and in 3 restricted areas it will give the solution to that room.";
	say "[line break]That's all. Push any key to continue.";
	wfak;

chapter woofandwarping

woofandwarping is an action applying to nothing.

understand the command "woof and warp" as something new.
understand the command "waw" as something new.
understand the command "ww" as something new.

understand "woof and warp" as woofandwarping.
understand "waw" as woofandwarping.
understand "ww" as woofandwarping.

carry out woofandwarping:
	if cadet space is visited:
		say "You need to restart the game to activate this jump. Or, at least, not have reached Cadet Space yet." instead;
	move Alec to way-out bluff;
	now woof-warp is true;
	the rule succeeds;

book fiddling

chapter jing

jing is an action applying to one number.

understand the command "j" as something new.

understand "j [number]" as jing.

carry out jing:
	if number understood is 1:
		move Alec to cross instead;
	if number understood is 2:
		move Alec to way-out bluff instead;
	say "Only 1-2 are valid for now.";
	the rule succeeds;

book diagnostics

book resetting mid-game

[ * There should be various things to try here if the tester wants to muck around ]

chapter skiping

[ * this is to let the beta tester skip to various areas]

skiping is an action applying to one number.
skip-1ing is an action out of world.

understand the command "skip" as something new.

understand "skip" as skip-1ing.

understand "skip [number]" as skiping.

carry out skip-1ing:
	try skiping -1 instead;

carry out skiping:
	let maxnum be the number of rows in table of skips;
	if number understood is 0:
		try restarting the game instead;
	if number understood is -2:
		end the story finally saying "You are testing the ending menu. Thanks for your work here[if debug-state is true], but you may want to type DS to set debug-state to false[end if]! (Note to self: turn debug-state off with DS to test it fully.)[line break]";
		the rule succeeds;
	if number understood is -3:
		end the story saying "You are testing the game-losing ending menu. Thanks for your work here!";
		the rule succeeds;
	if number understood is -1:
		let count be 0;
		repeat through table of skips:
			increment count;
			say "In addition to -3 to lose, -2 to win, -1 to list arguments, and 0 to restart, the following numbers jump you around:[paragraph break]";
			say "[count]. [skip-text entry][line break]";
		the rule succeeds;
	if number understood > maxnum:
		say "The only valid numbers are -2 to win, -1 (or no argument) to list skips, 0 (restart) or 1-[maxnum]." instead;
	choose row number understood in table of skips;
	consider the skip-rule entry;

table of skips
skip-text	skip-rule
"Cadet Space Jump"	csgo rule
"Sense Common Jump"	scgo rule
"Bluff Jump"	evcur rule

to jump-check (btr - a room):
	if btr is visited:
		say "You've already been to [btr], so this jump is as good as GONEAR, and I'm not changing the game state. Note there's a possibility of some wobbliness here, as I don't programmer-test fully for bad gonears.";
	move Alec to btr;

this is the csgo rule:
	jump-check cadet space;
	the rule succeeds;

this is the scgo rule:
	jump-check sense common;
	the rule succeeds;

this is the evcur rule:
	jump-check way-out bluff;
	the rule succeeds;

chapter wooding

[ * this pushes the player back to the start of the wood so we can test directional rotation as Alec makes his first 3 moves ]

wooding is an action out of world.

understand the command "wood" as something new.

understand "wood" as wooding.

carry out wooding:
	if effort token is not off-stage:
		say "WARNING: you've made progress in the actual game, so this may mess things up down the line.";
	move Alec to Thought Park, without printing a room description;
	now skip-baiter is true;
	the rule succeeds;

volume programmer testing - not for release

[ * this is basic info to start the game ]

when play begins (this is the set debug-state rule):
	now debug-state is true;
	now stop-on-bug is true;
	now ignore-wait is true;

when play begins (this is the table check rule):
	repeat through table of final buttons:
		if there is no btntalk entry:
			d "[btn entry] needs a btntalk entry!";

the set debug-state rule is listed first in the when play begins rules.

when play begins (this is the region check rule):
	let region-needed be false;
	let unvis-needed be true;
	repeat with RM running through rooms:
		if map region of RM is nothing:
			d "[RM] needs a region!";
			now region-needed is true;
		if RM is not a loc-to-write listed in table of unvisiteds and RM is not abstract:
			say "[RM] needs to be in the table of unvisiteds.";
			now unvis-needed is true;
	if region-needed is false:
		d "All rooms have regions, yay!";
	if unvis-needed is false:
		d "All rooms have unvisited text, yay!";

chapter sobing

[ * this toggles stopping on a bug so I don't send testers something awful]

sobing is an action out of world.

understand the command "sob" as something new.

understand "sob" as sobing.

carry out sobing:
	now stop-on-bug is whether or not stop-on-bug is true;
	say "Stop-on-bug is now [on-off of stop-on-bug].";
	the rule succeeds;

chapter vicing

[ * vic forces victory]

vicing is an action out of world.

understand the command "vic" as something new.

understand "vic" as vicing.

carry out vicing:
	end the story finally;
	consider the shutdown rules;
	the rule succeeds;

chapter montying

[* this turns testing stuff on and off. The table has information on all the tests.]

montying is an action applying to one topic.

widdershins is a direction. turnwise is a direction. the opposite of widdershins is turnwise. the opposite of turnwise is widdershins.

understand the command "monty" as something new.

understand "monty" as a mistake ("[monty-sum]")

to say monty-sum:
	say "MONTY usage for running a test-command every move:[paragraph break]";
	repeat through table of monties:
		say "[2da][test-title entry] can be turned on/off with [topic-as-text entry][line break]";
	say "[line break]MONTY FULL/ALL and MONTY NONE tracks all these every-move tries, or none of them.[no line break]";

understand "monty [text]" as montying.

monty-full is a truth state that varies.

carry out montying:
	let found-toggle be false;
	if the topic understood matches "all" or the topic understood matches "full":
		repeat through table of monties:
			now on-off entry is true;
		the rule succeeds;
	if the topic understood matches "none":
		repeat through table of monties:
			now on-off entry is false;
		the rule succeeds;
	repeat through table of monties:
		if the topic understood matches montopic entry:
			now on-off entry is whether or not on-off entry is false;
			say "[test-title entry] is now [if on-off entry is true]on[else]off[end if].";
			now found-toggle is true;
	if found-toggle is false:
		say "That wasn't a recognized flag for MONTY.[paragraph break][monty-sum][line break]";
	the rule succeeds;

table of monties
montopic (topic)	on-off	test-title (text)	test-action	topic-as-text (text)
"exits"	false	"LISTING EXITS"	try-exits rule	"exits"
"legend/hint"	false	"LEGEND HINTING"	try-hinting rule	"legend/hint"
"i/inventory"	false	"INVENTORY"	try-inventory rule	"i/inventory"
"s/smell"	false	"SMELLING"	try-smelling rule	"s/smell"
"l/listen"	false	"LISTENING"	try-listening rule	"l/listen"
"sc/score"	false	"SCORING"	try-scoring rule	"sc/score"
"dir/noway"	false	"GOING NOWHERE"	try-wid rule	"dir/noway"
"dirs"	false	"GOING BASIC DIRS"	try-dirs rule	"dirs"
"mood"	false	"MOOD tracking"	try-mood rule	"mood"
"think"	false	"THINK tracking"	try-think rule	"think"
"sleep"	false	"SLEEP tracking"	try-sleep rule	"sleep"

this is the try-exits rule:
	try exitsing;

this is the try-hinting rule:
	do nothing;

this is the try-inventory rule:
	try taking inventory;

this is the try-smelling rule:
	try smelling;

this is the try-listening rule:
	try listening;

this is the try-scoring rule:
	try requesting the score;

this is the try-wid rule:
	try going widdershins;

tracked-room is a room that varies.

this is the try-dirs rule:
	now tracked-room is location of Alec;
	say "[tracked-room] = base room.";
	shift-player inside;
	shift-player outside;
	shift-player east;
	shift-player west;
	shift-player south;
	shift-player north;

to shift-player (Q - a direction):
	say "Going [Q] from [location of Alec]:";
	try going q;
	move Alec to tracked-room, without printing a room description;

this is the try-mood rule:
	say "Your mood (upper right status) is [up-right].";

this is the try-think rule:
	try thinking;

this is the try-sleep rule:
	try sleeping;

every turn (this is the full monty test rule) :
	let test-output-yet be false;
	repeat through table of monties:
		if on-off entry is true:
			now test-output-yet is true;
			say "========[test-title entry]:[line break]";
			follow the test-action entry;
	if test-output-yet is true:
		say "========END TESTS[line break]";

volume testing - not for release

include Property Checking by Emily Short.

a thing can be abstract. a thing is usually not abstract.

a room can be abstract. a room is usually not abstract.

lalaland is abstract.

conceptville is abstract.

chapter endgming

[* quick stab at the endgame]

endgming is an action applying to nothing.

understand the command "endgm" as something new.

understand "endgm" as endgming.

carry out endgming:
	move snowflake special to bare cave;
	move Alec to bare cave;
	try entering snowflake special;
	the rule succeeds;

chapter dsing

dsing is an action out of world.

understand the command "ds" as something new.

understand "ds" as dsing.

carry out dsing:
	now debug-state is whether or not debug-state is false;
	say "Debug-state is now [on-off of debug-state].";
	the rule succeeds;

chapter xpalling

[* this explains all visible]

xpalling is an action out of world.

understand the command "xpall" as something new.

understand "xpall" as xpalling.

carry out xpalling:
	repeat with Q running through visible things:
		if Q is not Alec Smart:
			say "[Q]: ";
			try explaining Q;
	the rule succeeds;

book actual tests

[ * I have actual tests here and hope to organize them in the future]

test allangles with "n/n/n/wood/n/n/ne/wood/n/n/e/wood/n/n/se/wood/n/n/s/wood/n/ne/ne/wood/n/ne/e/wood/n/ne/se/wood/n/ne/s/wood/n/ne/w/wood/n/ne/nw/wood/n/ne/n/wood/n/e/s/wood/n/e/sw/wood/n/e/nw/wood/n/e/n/wood/n/se/w/wood/n/se/n/wood"

test w1 with "n/ne/e/n/x cot/x cot/x cot/e/n/get x furniture/x cot/g/g/e/put token in pocket/e/n/push furniture s/push furniture w/enter forge/d/".

test w1a with "test w1/u/e/put paper in coop/e"

test w2a with "get solution/u/e/use paper on coop/e/n/d/model roll/s/e/use device on prints/w/s/use bullet on net/n/n/use engine on auto/s".

test w2b with "get jars/u/e/use paper on coop/e/e/s/comment no/w/n/n/use buckle on auto/s/e/use bolt on prints/w/s/use hook on net/n".


test w2c with "get bottle/u/e/use paper on coop/e/e/n/track laugh/w/s/s/use strip on net/n/n/use guzzler gas on erotic auto/s/e/use bawl slime on charming prints/w"

test w3 with "d/divide grate/in/push 1i/enter special"

test tc with "touch common/s/test w2b/test w3"

test a1 with "test w1/test w2a/test w3".
test a2 with "test w1/test w2b/test w3".
test a3 with "test w1/test w2c/test w3".

test end with "gonear cave/1u/in"

test gas with "purloin bottle/gonear shock/track laugh/w/s/s/use strip on net/i"